/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_ip_diagnose_model;

import com.huawei.network.qasn.m_q_common.QAsnNVSList;
import com.huawei.network.qasn.m_q_common.QAsnSingleReturn;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnTracert
implements FStruct {
    public int neID = -1;
    public int pktSeq = -1;
    public byte[] midIp;
    public int minDelay = -1;
    public int avgDelay = -1;
    public int maxDelay = -1;
    public QAsnUniResID serviceFDN = null;
    public Integer poiLossRatio = null;
    public Integer poiSentPackets = null;
    public Integer poiReceivedPackets = null;
    public Integer poiOverRTDThresholdTimes = null;
    public QAsnSingleReturn poResult = null;
    public QAsnNVSList poExAttrList = null;

    public QAsnTracert() {
    }

    public QAsnTracert(QAsnTracert arg) {
        this.neID = arg.neID;
        this.pktSeq = arg.pktSeq;
        this.midIp = new byte[arg.midIp.length];
        System.arraycopy(arg.midIp, 0, this.midIp, 0, arg.midIp.length);
        this.minDelay = arg.minDelay;
        this.avgDelay = arg.avgDelay;
        this.maxDelay = arg.maxDelay;
        if (arg.serviceFDN != null) {
            this.serviceFDN = new QAsnUniResID(arg.serviceFDN);
        }
        if (arg.poiLossRatio != null) {
            this.poiLossRatio = arg.poiLossRatio;
        }
        if (arg.poiSentPackets != null) {
            this.poiSentPackets = arg.poiSentPackets;
        }
        if (arg.poiReceivedPackets != null) {
            this.poiReceivedPackets = arg.poiReceivedPackets;
        }
        if (arg.poiOverRTDThresholdTimes != null) {
            this.poiOverRTDThresholdTimes = arg.poiOverRTDThresholdTimes;
        }
        if (arg.poResult != null) {
            this.poResult = new QAsnSingleReturn(arg.poResult);
        }
        if (arg.poExAttrList != null) {
            this.poExAttrList = new QAsnNVSList(arg.poExAttrList);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.neID));
        enc.serializeInteger(BigInteger.valueOf(this.pktSeq));
        enc.serializeOctetString(this.midIp);
        enc.serializeInteger(BigInteger.valueOf(this.minDelay));
        enc.serializeInteger(BigInteger.valueOf(this.avgDelay));
        enc.serializeInteger(BigInteger.valueOf(this.maxDelay));
        if (this.serviceFDN != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            this.serviceFDN.serialize(enc);
        }
        if (this.poiLossRatio != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeInteger(BigInteger.valueOf(this.poiLossRatio.intValue()));
        }
        if (this.poiSentPackets != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)2));
            enc.serializeInteger(BigInteger.valueOf(this.poiSentPackets.intValue()));
        }
        if (this.poiReceivedPackets != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)3));
            enc.serializeInteger(BigInteger.valueOf(this.poiReceivedPackets.intValue()));
        }
        if (this.poiOverRTDThresholdTimes != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)4));
            enc.serializeInteger(BigInteger.valueOf(this.poiOverRTDThresholdTimes.intValue()));
        }
        if (this.poResult != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)5));
            this.poResult.serialize(enc);
        }
        if (this.poExAttrList != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)6));
            this.poExAttrList.serialize(enc);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.neID = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.pktSeq = bi.intValue();
        }
        this.midIp = dec.deserializeOctetString();
        bi = dec.deserializeInteger();
        if (null != bi) {
            this.minDelay = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.avgDelay = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.maxDelay = bi.intValue();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.serviceFDN = new QAsnUniResID();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.serviceFDN.deserialize(dec);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            this.poiLossRatio = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.poiLossRatio = bi.intValue();
            }
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            this.poiSentPackets = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)2));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.poiSentPackets = bi.intValue();
            }
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)3))) {
            this.poiReceivedPackets = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)3));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.poiReceivedPackets = bi.intValue();
            }
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)4))) {
            this.poiOverRTDThresholdTimes = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)4));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.poiOverRTDThresholdTimes = bi.intValue();
            }
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)5))) {
            this.poResult = new QAsnSingleReturn();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)5));
            this.poResult.deserialize(dec);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)6))) {
            this.poExAttrList = new QAsnNVSList();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)6));
            this.poExAttrList.deserialize(dec);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("neID = ");
        os.print(this.neID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("pktSeq = ");
        os.print(this.pktSeq);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("midIp = ");
        os.print(FStruFormat.convertToString((byte[])this.midIp));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("minDelay = ");
        os.print(this.minDelay);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("avgDelay = ");
        os.print(this.avgDelay);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("maxDelay = ");
        os.print(this.maxDelay);
        os.println(',');
        if (this.serviceFDN != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("serviceFDN = ");
            this.serviceFDN.print(os, indent + 2);
            os.println(',');
        }
        if (this.poiLossRatio != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poiLossRatio = ");
            os.print(this.poiLossRatio.toString());
            os.println(',');
        }
        if (this.poiSentPackets != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poiSentPackets = ");
            os.print(this.poiSentPackets.toString());
            os.println(',');
        }
        if (this.poiReceivedPackets != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poiReceivedPackets = ");
            os.print(this.poiReceivedPackets.toString());
            os.println(',');
        }
        if (this.poiOverRTDThresholdTimes != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poiOverRTDThresholdTimes = ");
            os.print(this.poiOverRTDThresholdTimes.toString());
            os.println(',');
        }
        if (this.poResult != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poResult = ");
            this.poResult.print(os, indent + 2);
            os.println(',');
        }
        if (this.poExAttrList != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poExAttrList = ");
            this.poExAttrList.print(os, indent + 2);
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

