/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_ip_diagnose_model;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnPing
implements FStruct {
    public int neID = -1;
    public byte[] destination;
    public int pktLen = -1;
    public int pktSeq = -1;
    public int ttl = -1;
    public int delay = -1;
    public QAsnUniResID serviceFDN = null;

    public QAsnPing() {
    }

    public QAsnPing(QAsnPing arg) {
        this.neID = arg.neID;
        this.destination = new byte[arg.destination.length];
        System.arraycopy(arg.destination, 0, this.destination, 0, arg.destination.length);
        this.pktLen = arg.pktLen;
        this.pktSeq = arg.pktSeq;
        this.ttl = arg.ttl;
        this.delay = arg.delay;
        if (arg.serviceFDN != null) {
            this.serviceFDN = new QAsnUniResID(arg.serviceFDN);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.neID));
        enc.serializeOctetString(this.destination);
        enc.serializeInteger(BigInteger.valueOf(this.pktLen));
        enc.serializeInteger(BigInteger.valueOf(this.pktSeq));
        enc.serializeInteger(BigInteger.valueOf(this.ttl));
        enc.serializeInteger(BigInteger.valueOf(this.delay));
        if (this.serviceFDN != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            this.serviceFDN.serialize(enc);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.neID = bi.intValue();
        }
        this.destination = dec.deserializeOctetString();
        bi = dec.deserializeInteger();
        if (null != bi) {
            this.pktLen = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.pktSeq = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.ttl = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.delay = bi.intValue();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.serviceFDN = new QAsnUniResID();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.serviceFDN.deserialize(dec);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("neID = ");
        os.print(this.neID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("destination = ");
        os.print(FStruFormat.convertToString((byte[])this.destination));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("pktLen = ");
        os.print(this.pktLen);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("pktSeq = ");
        os.print(this.pktSeq);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("ttl = ");
        os.print(this.ttl);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("delay = ");
        os.print(this.delay);
        os.println(',');
        if (this.serviceFDN != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("serviceFDN = ");
            this.serviceFDN.print(os, indent + 2);
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

