/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_ip_diagnose_model;

import com.huawei.network.qasn.m_q_common.QAsnIPAddress;
import com.huawei.network.qasn.m_q_common.QAsnNVSList;
import com.huawei.network.qasn.m_q_common.QAsnSingleReturn;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_diagnose_model.QAsnL2L3MepBase;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnL2L3Mep
implements FStruct {
    public QAsnL2L3MepBase base = new QAsnL2L3MepBase();
    public QAsnUniResID service = new QAsnUniResID();
    public QAsnUniResID vuni = new QAsnUniResID();
    public QAsnIPAddress mepIp = new QAsnIPAddress();
    public byte[] mipMac;
    public int mepVlan = -1;
    public QAsnIPAddress poMipIp = null;
    public QAsnSingleReturn poOperResult = null;
    public QAsnNVSList poExAttrList = null;

    public QAsnL2L3Mep() {
    }

    public QAsnL2L3Mep(QAsnL2L3Mep arg) {
        this.base = new QAsnL2L3MepBase(arg.base);
        this.service = new QAsnUniResID(arg.service);
        this.vuni = new QAsnUniResID(arg.vuni);
        this.mepIp = new QAsnIPAddress(arg.mepIp);
        this.mipMac = new byte[arg.mipMac.length];
        System.arraycopy(arg.mipMac, 0, this.mipMac, 0, arg.mipMac.length);
        this.mepVlan = arg.mepVlan;
        if (arg.poMipIp != null) {
            this.poMipIp = new QAsnIPAddress(arg.poMipIp);
        }
        if (arg.poOperResult != null) {
            this.poOperResult = new QAsnSingleReturn(arg.poOperResult);
        }
        if (arg.poExAttrList != null) {
            this.poExAttrList = new QAsnNVSList(arg.poExAttrList);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.base.serialize(enc);
        this.service.serialize(enc);
        this.vuni.serialize(enc);
        this.mepIp.serialize(enc);
        enc.serializeOctetString(this.mipMac);
        enc.serializeInteger(BigInteger.valueOf(this.mepVlan));
        if (this.poMipIp != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            this.poMipIp.serialize(enc);
        }
        if (this.poOperResult != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            this.poOperResult.serialize(enc);
        }
        if (this.poExAttrList != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)2));
            this.poExAttrList.serialize(enc);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.base.deserialize(dec);
        this.service.deserialize(dec);
        this.vuni.deserialize(dec);
        this.mepIp.deserialize(dec);
        this.mipMac = dec.deserializeOctetString();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.mepVlan = bi.intValue();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.poMipIp = new QAsnIPAddress();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.poMipIp.deserialize(dec);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            this.poOperResult = new QAsnSingleReturn();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.poOperResult.deserialize(dec);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            this.poExAttrList = new QAsnNVSList();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)2));
            this.poExAttrList.deserialize(dec);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("base = ");
        this.base.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("service = ");
        this.service.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("vuni = ");
        this.vuni.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("mepIp = ");
        this.mepIp.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("mipMac = ");
        os.print(FStruFormat.convertToString((byte[])this.mipMac));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("mepVlan = ");
        os.print(this.mepVlan);
        os.println(',');
        if (this.poMipIp != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poMipIp = ");
            this.poMipIp.print(os, indent + 2);
            os.println(',');
        }
        if (this.poOperResult != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poOperResult = ");
            this.poOperResult.print(os, indent + 2);
            os.println(',');
        }
        if (this.poExAttrList != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poExAttrList = ");
            this.poExAttrList.print(os, indent + 2);
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

