/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_ip_ctp_model;

import com.huawei.network.qasn.m_q_common.QAsnIPAddress;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class QAsnDLCI
implements FStruct {
    public int dlci = -1;
    public QAsnIPAddress mapIP = new QAsnIPAddress();
    public Integer poOperMask = null;

    public QAsnDLCI() {
    }

    public QAsnDLCI(QAsnDLCI arg) {
        this.dlci = arg.dlci;
        this.mapIP = new QAsnIPAddress(arg.mapIP);
        if (arg.poOperMask != null) {
            this.poOperMask = arg.poOperMask;
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.dlci));
        this.mapIP.serialize(enc);
        if (this.poOperMask != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(BigInteger.valueOf(this.poOperMask.intValue()));
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.dlci = bi.intValue();
        }
        this.mapIP.deserialize(dec);
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.poOperMask = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.poOperMask = bi.intValue();
            }
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("dlci = ");
        os.print(this.dlci);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("mapIP = ");
        this.mapIP.print(os, indent + 2);
        os.println(',');
        if (this.poOperMask != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poOperMask = ");
            os.print(this.poOperMask.toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

