/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_ip_common_model;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnVrInfo
implements FStruct {
    public int vrID = -1;
    public byte[] vrName;
    public byte[] poVrDescr = null;

    public QAsnVrInfo() {
    }

    public QAsnVrInfo(QAsnVrInfo arg) {
        this.vrID = arg.vrID;
        this.vrName = new byte[arg.vrName.length];
        System.arraycopy(arg.vrName, 0, this.vrName, 0, arg.vrName.length);
        if (arg.poVrDescr != null) {
            this.poVrDescr = new byte[arg.poVrDescr.length];
            System.arraycopy(arg.poVrDescr, 0, this.poVrDescr, 0, arg.poVrDescr.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.vrID));
        enc.serializeOctetString(this.vrName);
        if (this.poVrDescr != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.poVrDescr);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.vrID = bi.intValue();
        }
        this.vrName = dec.deserializeOctetString();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.poVrDescr = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("vrID = ");
        os.print(this.vrID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("vrName = ");
        os.print(FStruFormat.convertToString((byte[])this.vrName));
        os.println(',');
        if (this.poVrDescr != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poVrDescr = ");
            os.print(FStruFormat.convertToString((byte[])this.poVrDescr));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

