/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_ip_common_model;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnPortAndVlanData
implements FStruct {
    public int iNeID = -1;
    public byte[] strPortFDN;
    public int iVlanID = -1;
    public byte[] poUniFDN = null;
    public byte[] poServiceFDN = null;
    public Integer poServiceType = null;

    public QAsnPortAndVlanData() {
    }

    public QAsnPortAndVlanData(QAsnPortAndVlanData arg) {
        this.iNeID = arg.iNeID;
        this.strPortFDN = new byte[arg.strPortFDN.length];
        System.arraycopy(arg.strPortFDN, 0, this.strPortFDN, 0, arg.strPortFDN.length);
        this.iVlanID = arg.iVlanID;
        if (arg.poUniFDN != null) {
            this.poUniFDN = new byte[arg.poUniFDN.length];
            System.arraycopy(arg.poUniFDN, 0, this.poUniFDN, 0, arg.poUniFDN.length);
        }
        if (arg.poServiceFDN != null) {
            this.poServiceFDN = new byte[arg.poServiceFDN.length];
            System.arraycopy(arg.poServiceFDN, 0, this.poServiceFDN, 0, arg.poServiceFDN.length);
        }
        if (arg.poServiceType != null) {
            this.poServiceType = arg.poServiceType;
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.iNeID));
        enc.serializeOctetString(this.strPortFDN);
        enc.serializeInteger(BigInteger.valueOf(this.iVlanID));
        if (this.poUniFDN != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.poUniFDN);
        }
        if (this.poServiceFDN != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeOctetString(this.poServiceFDN);
        }
        if (this.poServiceType != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)2));
            enc.serializeInteger(BigInteger.valueOf(this.poServiceType.intValue()));
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.iNeID = bi.intValue();
        }
        this.strPortFDN = dec.deserializeOctetString();
        bi = dec.deserializeInteger();
        if (null != bi) {
            this.iVlanID = bi.intValue();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.poUniFDN = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.poServiceFDN = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            this.poServiceType = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)2));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.poServiceType = bi.intValue();
            }
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iNeID = ");
        os.print(this.iNeID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strPortFDN = ");
        os.print(FStruFormat.convertToString((byte[])this.strPortFDN));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iVlanID = ");
        os.print(this.iVlanID);
        os.println(',');
        if (this.poUniFDN != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poUniFDN = ");
            os.print(FStruFormat.convertToString((byte[])this.poUniFDN));
            os.println(',');
        }
        if (this.poServiceFDN != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poServiceFDN = ");
            os.print(FStruFormat.convertToString((byte[])this.poServiceFDN));
            os.println(',');
        }
        if (this.poServiceType != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poServiceType = ");
            os.print(this.poServiceType.toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

