/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_ip_common_model;

import com.huawei.network.qasn.m_q_common.QAsnNVSList;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnPingParam
implements FStruct {
    public byte[] sourceIp;
    public byte[] destination;
    public byte[] destMask;
    public int echoRequest = -1;
    public int ttl = -1;
    public int sendDistant = -1;
    public int sendMessagelen = -1;
    public int replyTimeOut = -1;
    public Integer replyType = null;
    public Integer poEXP = null;
    public Integer poLspVersion = null;
    public Integer poLossRatioThreshold = null;
    public Integer poDSDomain = null;
    public Integer poRTDThreshold = null;
    public Integer poUniType = null;
    public QAsnUniResID poUniKey = null;
    public Integer poTos = null;
    public QAsnNVSList poExAttrList = null;

    public QAsnPingParam() {
    }

    public QAsnPingParam(QAsnPingParam arg) {
        this.sourceIp = new byte[arg.sourceIp.length];
        System.arraycopy(arg.sourceIp, 0, this.sourceIp, 0, arg.sourceIp.length);
        this.destination = new byte[arg.destination.length];
        System.arraycopy(arg.destination, 0, this.destination, 0, arg.destination.length);
        this.destMask = new byte[arg.destMask.length];
        System.arraycopy(arg.destMask, 0, this.destMask, 0, arg.destMask.length);
        this.echoRequest = arg.echoRequest;
        this.ttl = arg.ttl;
        this.sendDistant = arg.sendDistant;
        this.sendMessagelen = arg.sendMessagelen;
        this.replyTimeOut = arg.replyTimeOut;
        if (arg.replyType != null) {
            this.replyType = arg.replyType;
        }
        if (arg.poEXP != null) {
            this.poEXP = arg.poEXP;
        }
        if (arg.poLspVersion != null) {
            this.poLspVersion = arg.poLspVersion;
        }
        if (arg.poLossRatioThreshold != null) {
            this.poLossRatioThreshold = arg.poLossRatioThreshold;
        }
        if (arg.poDSDomain != null) {
            this.poDSDomain = arg.poDSDomain;
        }
        if (arg.poRTDThreshold != null) {
            this.poRTDThreshold = arg.poRTDThreshold;
        }
        if (arg.poUniType != null) {
            this.poUniType = arg.poUniType;
        }
        if (arg.poUniKey != null) {
            this.poUniKey = new QAsnUniResID(arg.poUniKey);
        }
        if (arg.poTos != null) {
            this.poTos = arg.poTos;
        }
        if (arg.poExAttrList != null) {
            this.poExAttrList = new QAsnNVSList(arg.poExAttrList);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.sourceIp);
        enc.serializeOctetString(this.destination);
        enc.serializeOctetString(this.destMask);
        enc.serializeInteger(BigInteger.valueOf(this.echoRequest));
        enc.serializeInteger(BigInteger.valueOf(this.ttl));
        enc.serializeInteger(BigInteger.valueOf(this.sendDistant));
        enc.serializeInteger(BigInteger.valueOf(this.sendMessagelen));
        enc.serializeInteger(BigInteger.valueOf(this.replyTimeOut));
        if (this.replyType != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(BigInteger.valueOf(this.replyType.intValue()));
        }
        if (this.poEXP != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeInteger(BigInteger.valueOf(this.poEXP.intValue()));
        }
        if (this.poLspVersion != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)2));
            enc.serializeInteger(BigInteger.valueOf(this.poLspVersion.intValue()));
        }
        if (this.poLossRatioThreshold != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)3));
            enc.serializeInteger(BigInteger.valueOf(this.poLossRatioThreshold.intValue()));
        }
        if (this.poDSDomain != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)4));
            enc.serializeInteger(BigInteger.valueOf(this.poDSDomain.intValue()));
        }
        if (this.poRTDThreshold != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)5));
            enc.serializeInteger(BigInteger.valueOf(this.poRTDThreshold.intValue()));
        }
        if (this.poUniType != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)6));
            enc.serializeInteger(BigInteger.valueOf(this.poUniType.intValue()));
        }
        if (this.poUniKey != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)7));
            this.poUniKey.serialize(enc);
        }
        if (this.poTos != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)8));
            enc.serializeInteger(BigInteger.valueOf(this.poTos.intValue()));
        }
        if (this.poExAttrList != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)9));
            this.poExAttrList.serialize(enc);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.sourceIp = dec.deserializeOctetString();
        this.destination = dec.deserializeOctetString();
        this.destMask = dec.deserializeOctetString();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.echoRequest = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.ttl = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.sendDistant = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.sendMessagelen = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.replyTimeOut = bi.intValue();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.replyType = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.replyType = bi.intValue();
            }
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            this.poEXP = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.poEXP = bi.intValue();
            }
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            this.poLspVersion = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)2));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.poLspVersion = bi.intValue();
            }
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)3))) {
            this.poLossRatioThreshold = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)3));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.poLossRatioThreshold = bi.intValue();
            }
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)4))) {
            this.poDSDomain = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)4));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.poDSDomain = bi.intValue();
            }
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)5))) {
            this.poRTDThreshold = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)5));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.poRTDThreshold = bi.intValue();
            }
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)6))) {
            this.poUniType = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)6));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.poUniType = bi.intValue();
            }
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)7))) {
            this.poUniKey = new QAsnUniResID();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)7));
            this.poUniKey.deserialize(dec);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)8))) {
            this.poTos = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)8));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.poTos = bi.intValue();
            }
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)9))) {
            this.poExAttrList = new QAsnNVSList();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)9));
            this.poExAttrList.deserialize(dec);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("sourceIp = ");
        os.print(FStruFormat.convertToString((byte[])this.sourceIp));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("destination = ");
        os.print(FStruFormat.convertToString((byte[])this.destination));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("destMask = ");
        os.print(FStruFormat.convertToString((byte[])this.destMask));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("echoRequest = ");
        os.print(this.echoRequest);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("ttl = ");
        os.print(this.ttl);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("sendDistant = ");
        os.print(this.sendDistant);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("sendMessagelen = ");
        os.print(this.sendMessagelen);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("replyTimeOut = ");
        os.print(this.replyTimeOut);
        os.println(',');
        if (this.replyType != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("replyType = ");
            os.print(this.replyType.toString());
            os.println(',');
        }
        if (this.poEXP != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poEXP = ");
            os.print(this.poEXP.toString());
            os.println(',');
        }
        if (this.poLspVersion != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poLspVersion = ");
            os.print(this.poLspVersion.toString());
            os.println(',');
        }
        if (this.poLossRatioThreshold != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poLossRatioThreshold = ");
            os.print(this.poLossRatioThreshold.toString());
            os.println(',');
        }
        if (this.poDSDomain != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poDSDomain = ");
            os.print(this.poDSDomain.toString());
            os.println(',');
        }
        if (this.poRTDThreshold != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poRTDThreshold = ");
            os.print(this.poRTDThreshold.toString());
            os.println(',');
        }
        if (this.poUniType != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poUniType = ");
            os.print(this.poUniType.toString());
            os.println(',');
        }
        if (this.poUniKey != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poUniKey = ");
            this.poUniKey.print(os, indent + 2);
            os.println(',');
        }
        if (this.poTos != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poTos = ");
            os.print(this.poTos.toString());
            os.println(',');
        }
        if (this.poExAttrList != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poExAttrList = ");
            this.poExAttrList.print(os, indent + 2);
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

