/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_ip_common_model;

import com.huawei.network.qasn.m_q_common.QAsnIPAddress;
import com.huawei.network.qasn.m_q_common.QAsnSingleReturn;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class QAsnPTNMCSPPath
implements FStruct {
    public BigInteger spPathID;
    public BigInteger spChannelID;
    public QAsnIPAddress spPeerIP = new QAsnIPAddress();
    public QAsnUniResID poTunnelKey = null;
    public QAsnSingleReturn result = null;

    public QAsnPTNMCSPPath() {
    }

    public QAsnPTNMCSPPath(QAsnPTNMCSPPath arg) {
        this.spPathID = arg.spPathID;
        this.spChannelID = arg.spChannelID;
        this.spPeerIP = new QAsnIPAddress(arg.spPeerIP);
        if (arg.poTunnelKey != null) {
            this.poTunnelKey = new QAsnUniResID(arg.poTunnelKey);
        }
        if (arg.result != null) {
            this.result = new QAsnSingleReturn(arg.result);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.spPathID);
        enc.serializeInteger(this.spChannelID);
        this.spPeerIP.serialize(enc);
        if (this.poTunnelKey != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            this.poTunnelKey.serialize(enc);
        }
        if (this.result != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            this.result.serialize(enc);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.spPathID = dec.deserializeInteger();
        this.spChannelID = dec.deserializeInteger();
        this.spPeerIP.deserialize(dec);
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.poTunnelKey = new QAsnUniResID();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.poTunnelKey.deserialize(dec);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            this.result = new QAsnSingleReturn();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.result.deserialize(dec);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("spPathID = ");
        os.print(this.spPathID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("spChannelID = ");
        os.print(this.spChannelID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("spPeerIP = ");
        this.spPeerIP.print(os, indent + 2);
        os.println(',');
        if (this.poTunnelKey != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poTunnelKey = ");
            this.poTunnelKey.print(os, indent + 2);
            os.println(',');
        }
        if (this.result != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("result = ");
            this.result.print(os, indent + 2);
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

