/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_ip_common_model;

import com.huawei.network.qasn.m_q_common.QAsnNVSList;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnIPPrefixNode
implements FStruct {
    public int matchMode = -1;
    public byte[] ipAddress;
    public byte[] ipMask;
    public Integer poGreatValue = null;
    public Integer poLessVlaue = null;
    public QAsnNVSList poExAttrList = null;

    public QAsnIPPrefixNode() {
    }

    public QAsnIPPrefixNode(QAsnIPPrefixNode arg) {
        this.matchMode = arg.matchMode;
        this.ipAddress = new byte[arg.ipAddress.length];
        System.arraycopy(arg.ipAddress, 0, this.ipAddress, 0, arg.ipAddress.length);
        this.ipMask = new byte[arg.ipMask.length];
        System.arraycopy(arg.ipMask, 0, this.ipMask, 0, arg.ipMask.length);
        if (arg.poGreatValue != null) {
            this.poGreatValue = arg.poGreatValue;
        }
        if (arg.poLessVlaue != null) {
            this.poLessVlaue = arg.poLessVlaue;
        }
        if (arg.poExAttrList != null) {
            this.poExAttrList = new QAsnNVSList(arg.poExAttrList);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.matchMode));
        enc.serializeOctetString(this.ipAddress);
        enc.serializeOctetString(this.ipMask);
        if (this.poGreatValue != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(BigInteger.valueOf(this.poGreatValue.intValue()));
        }
        if (this.poLessVlaue != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeInteger(BigInteger.valueOf(this.poLessVlaue.intValue()));
        }
        if (this.poExAttrList != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)2));
            this.poExAttrList.serialize(enc);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.matchMode = bi.intValue();
        }
        this.ipAddress = dec.deserializeOctetString();
        this.ipMask = dec.deserializeOctetString();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.poGreatValue = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.poGreatValue = bi.intValue();
            }
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            this.poLessVlaue = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.poLessVlaue = bi.intValue();
            }
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            this.poExAttrList = new QAsnNVSList();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)2));
            this.poExAttrList.deserialize(dec);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("matchMode = ");
        os.print(this.matchMode);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("ipAddress = ");
        os.print(FStruFormat.convertToString((byte[])this.ipAddress));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("ipMask = ");
        os.print(FStruFormat.convertToString((byte[])this.ipMask));
        os.println(',');
        if (this.poGreatValue != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poGreatValue = ");
            os.print(this.poGreatValue.toString());
            os.println(',');
        }
        if (this.poLessVlaue != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poLessVlaue = ");
            os.print(this.poLessVlaue.toString());
            os.println(',');
        }
        if (this.poExAttrList != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poExAttrList = ");
            this.poExAttrList.print(os, indent + 2);
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

