/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_inventory_ttp;

import com.huawei.network.qasn.m_q_common.QAsnSingleReturn;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnTTPAttrValue
implements FStruct {
    public int attrId = -1;
    public int attrAccess = -1;
    public byte[] attrValue;
    public QAsnSingleReturn errCode = new QAsnSingleReturn();

    public QAsnTTPAttrValue() {
    }

    public QAsnTTPAttrValue(QAsnTTPAttrValue arg) {
        this.attrId = arg.attrId;
        this.attrAccess = arg.attrAccess;
        this.attrValue = new byte[arg.attrValue.length];
        System.arraycopy(arg.attrValue, 0, this.attrValue, 0, arg.attrValue.length);
        this.errCode = new QAsnSingleReturn(arg.errCode);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.attrId));
        enc.serializeInteger(BigInteger.valueOf(this.attrAccess));
        enc.serializeOctetString(this.attrValue);
        this.errCode.serialize(enc);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.attrId = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.attrAccess = bi.intValue();
        }
        this.attrValue = dec.deserializeOctetString();
        this.errCode.deserialize(dec);
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("attrId = ");
        os.print(this.attrId);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("attrAccess = ");
        os.print(this.attrAccess);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("attrValue = ");
        os.print(FStruFormat.convertToString((byte[])this.attrValue));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("errCode = ");
        this.errCode.print(os, indent + 2);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

