/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_inventory_slot;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnSlotContent
implements FStruct {
    public int slotID = -1;
    public Integer subSlotID = null;
    public byte[] name = null;
    public byte[] userLabel = null;
    public byte[] owner = null;

    public QAsnSlotContent() {
    }

    public QAsnSlotContent(QAsnSlotContent arg) {
        this.slotID = arg.slotID;
        if (arg.subSlotID != null) {
            this.subSlotID = arg.subSlotID;
        }
        if (arg.name != null) {
            this.name = new byte[arg.name.length];
            System.arraycopy(arg.name, 0, this.name, 0, arg.name.length);
        }
        if (arg.userLabel != null) {
            this.userLabel = new byte[arg.userLabel.length];
            System.arraycopy(arg.userLabel, 0, this.userLabel, 0, arg.userLabel.length);
        }
        if (arg.owner != null) {
            this.owner = new byte[arg.owner.length];
            System.arraycopy(arg.owner, 0, this.owner, 0, arg.owner.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.slotID));
        if (this.subSlotID != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(BigInteger.valueOf(this.subSlotID.intValue()));
        }
        if (this.name != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeOctetString(this.name);
        }
        if (this.userLabel != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)2));
            enc.serializeOctetString(this.userLabel);
        }
        if (this.owner != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)3));
            enc.serializeOctetString(this.owner);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.slotID = bi.intValue();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.subSlotID = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.subSlotID = bi.intValue();
            }
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.name = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)2));
            this.userLabel = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)3))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)3));
            this.owner = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("slotID = ");
        os.print(this.slotID);
        os.println(',');
        if (this.subSlotID != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("subSlotID = ");
            os.print(this.subSlotID.toString());
            os.println(',');
        }
        if (this.name != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("name = ");
            os.print(FStruFormat.convertToString((byte[])this.name));
            os.println(',');
        }
        if (this.userLabel != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("userLabel = ");
            os.print(FStruFormat.convertToString((byte[])this.userLabel));
            os.println(',');
        }
        if (this.owner != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("owner = ");
            os.print(FStruFormat.convertToString((byte[])this.owner));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

