/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_inventory_port;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class QAsnOTNClientAttrInfo
implements FStruct {
    public int clientService = -1;
    public BigInteger clientVelocity;
    public BigInteger maxLevel;
    public BigInteger minLevel;

    public QAsnOTNClientAttrInfo() {
    }

    public QAsnOTNClientAttrInfo(QAsnOTNClientAttrInfo arg) {
        this.clientService = arg.clientService;
        this.clientVelocity = arg.clientVelocity;
        this.maxLevel = arg.maxLevel;
        this.minLevel = arg.minLevel;
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.clientService));
        enc.serializeInteger(this.clientVelocity);
        enc.serializeInteger(this.maxLevel);
        enc.serializeInteger(this.minLevel);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.clientService = bi.intValue();
        }
        this.clientVelocity = dec.deserializeInteger();
        this.maxLevel = dec.deserializeInteger();
        this.minLevel = dec.deserializeInteger();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("clientService = ");
        os.print(this.clientService);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("clientVelocity = ");
        os.print(this.clientVelocity.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("maxLevel = ");
        os.print(this.maxLevel.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("minLevel = ");
        os.print(this.minLevel.toString());
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

