/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_inventory_port;

import com.huawei.network.qasn.m_q_common.QAsnNVSList;
import com.huawei.network.qasn.m_q_inventory_port.QAsnODNEPortInfoList;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnODDataBackupReq
implements FStruct {
    public int userID = -1;
    public QAsnODNEPortInfoList nePortInfoList = new QAsnODNEPortInfoList();
    public byte[] savePath;
    public byte[] ipAddress;
    public QAsnNVSList nvList = new QAsnNVSList();

    public QAsnODDataBackupReq() {
    }

    public QAsnODDataBackupReq(QAsnODDataBackupReq arg) {
        this.userID = arg.userID;
        this.nePortInfoList = new QAsnODNEPortInfoList(arg.nePortInfoList);
        this.savePath = new byte[arg.savePath.length];
        System.arraycopy(arg.savePath, 0, this.savePath, 0, arg.savePath.length);
        this.ipAddress = new byte[arg.ipAddress.length];
        System.arraycopy(arg.ipAddress, 0, this.ipAddress, 0, arg.ipAddress.length);
        this.nvList = new QAsnNVSList(arg.nvList);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.userID));
        this.nePortInfoList.serialize(enc);
        enc.serializeOctetString(this.savePath);
        enc.serializeOctetString(this.ipAddress);
        this.nvList.serialize(enc);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.userID = bi.intValue();
        }
        this.nePortInfoList.deserialize(dec);
        this.savePath = dec.deserializeOctetString();
        this.ipAddress = dec.deserializeOctetString();
        this.nvList.deserialize(dec);
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("userID = ");
        os.print(this.userID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("nePortInfoList = ");
        this.nePortInfoList.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("savePath = ");
        os.print(FStruFormat.convertToString((byte[])this.savePath));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("ipAddress = ");
        os.print(FStruFormat.convertToString((byte[])this.ipAddress));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("nvList = ");
        this.nvList.print(os, indent + 2);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

