/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_inventory_port;

import com.huawei.network.qasn.m_q_common.QAsnPortIndex;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class QAsnNEECCPortInfo
implements FStruct {
    public QAsnPortIndex port = new QAsnPortIndex();
    public BigInteger eccStatus;
    public BigInteger protocol;
    public BigInteger poWorkState = null;

    public QAsnNEECCPortInfo() {
    }

    public QAsnNEECCPortInfo(QAsnNEECCPortInfo arg) {
        this.port = new QAsnPortIndex(arg.port);
        this.eccStatus = arg.eccStatus;
        this.protocol = arg.protocol;
        if (arg.poWorkState != null) {
            this.poWorkState = arg.poWorkState;
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.port.serialize(enc);
        enc.serializeInteger(this.eccStatus);
        enc.serializeInteger(this.protocol);
        if (this.poWorkState != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(this.poWorkState);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.port.deserialize(dec);
        this.eccStatus = dec.deserializeInteger();
        this.protocol = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.poWorkState = dec.deserializeInteger();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("port = ");
        this.port.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("eccStatus = ");
        os.print(this.eccStatus.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("protocol = ");
        os.print(this.protocol.toString());
        os.println(',');
        if (this.poWorkState != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poWorkState = ");
            os.print(this.poWorkState.toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

