/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_inventory_port;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class QAsnMSOtnFDNInfo
implements FStruct {
    public QAsnUniResID srcFDN = new QAsnUniResID();
    public QAsnUniResID snkFDN = new QAsnUniResID();
    public int trailID = -1;

    public QAsnMSOtnFDNInfo() {
    }

    public QAsnMSOtnFDNInfo(QAsnMSOtnFDNInfo arg) {
        this.srcFDN = new QAsnUniResID(arg.srcFDN);
        this.snkFDN = new QAsnUniResID(arg.snkFDN);
        this.trailID = arg.trailID;
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.srcFDN.serialize(enc);
        this.snkFDN.serialize(enc);
        enc.serializeInteger(BigInteger.valueOf(this.trailID));
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.srcFDN.deserialize(dec);
        this.snkFDN.deserialize(dec);
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.trailID = bi.intValue();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("srcFDN = ");
        this.srcFDN.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("snkFDN = ");
        this.snkFDN.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("trailID = ");
        os.print(this.trailID);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

