/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_inventory_port;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnIFPowerAttrs
implements FStruct {
    public byte[] txPow;
    public byte[] txPowRange;
    public byte[] actTxPow;
    public byte[] powRecv = null;
    public byte[] actRxPow;
    public int txStatus = -1;
    public int actTxStatus = -1;

    public QAsnIFPowerAttrs() {
    }

    public QAsnIFPowerAttrs(QAsnIFPowerAttrs arg) {
        this.txPow = new byte[arg.txPow.length];
        System.arraycopy(arg.txPow, 0, this.txPow, 0, arg.txPow.length);
        this.txPowRange = new byte[arg.txPowRange.length];
        System.arraycopy(arg.txPowRange, 0, this.txPowRange, 0, arg.txPowRange.length);
        this.actTxPow = new byte[arg.actTxPow.length];
        System.arraycopy(arg.actTxPow, 0, this.actTxPow, 0, arg.actTxPow.length);
        if (arg.powRecv != null) {
            this.powRecv = new byte[arg.powRecv.length];
            System.arraycopy(arg.powRecv, 0, this.powRecv, 0, arg.powRecv.length);
        }
        this.actRxPow = new byte[arg.actRxPow.length];
        System.arraycopy(arg.actRxPow, 0, this.actRxPow, 0, arg.actRxPow.length);
        this.txStatus = arg.txStatus;
        this.actTxStatus = arg.actTxStatus;
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.txPow);
        enc.serializeOctetString(this.txPowRange);
        enc.serializeOctetString(this.actTxPow);
        if (this.powRecv != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.powRecv);
        }
        enc.serializeOctetString(this.actRxPow);
        enc.serializeInteger(BigInteger.valueOf(this.txStatus));
        enc.serializeInteger(BigInteger.valueOf(this.actTxStatus));
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.txPow = dec.deserializeOctetString();
        this.txPowRange = dec.deserializeOctetString();
        this.actTxPow = dec.deserializeOctetString();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.powRecv = dec.deserializeOctetString();
        }
        this.actRxPow = dec.deserializeOctetString();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.txStatus = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.actTxStatus = bi.intValue();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("txPow = ");
        os.print(FStruFormat.convertToString((byte[])this.txPow));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("txPowRange = ");
        os.print(FStruFormat.convertToString((byte[])this.txPowRange));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("actTxPow = ");
        os.print(FStruFormat.convertToString((byte[])this.actTxPow));
        os.println(',');
        if (this.powRecv != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("powRecv = ");
            os.print(FStruFormat.convertToString((byte[])this.powRecv));
            os.println(',');
        }
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("actRxPow = ");
        os.print(FStruFormat.convertToString((byte[])this.actRxPow));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("txStatus = ");
        os.print(this.txStatus);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("actTxStatus = ");
        os.print(this.actTxStatus);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

