/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_inventory_port;

import com.huawei.network.qasn.m_q_common.QAsnLayerRateList;
import com.huawei.network.qasn.m_q_common.QAsnPortIndexList;
import com.huawei.network.qasn.m_q_inventory_port.QAsnOTNPortAttrTemplate;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class QAsnGetOTNPortInfoReq
implements FStruct {
    public int userID = -1;
    public QAsnPortIndexList portIndexList = new QAsnPortIndexList();
    public int qryType = -1;
    public QAsnLayerRateList levelList = null;
    public QAsnOTNPortAttrTemplate attrTemplate = null;

    public QAsnGetOTNPortInfoReq() {
    }

    public QAsnGetOTNPortInfoReq(QAsnGetOTNPortInfoReq arg) {
        this.userID = arg.userID;
        this.portIndexList = new QAsnPortIndexList(arg.portIndexList);
        this.qryType = arg.qryType;
        if (arg.levelList != null) {
            this.levelList = new QAsnLayerRateList(arg.levelList);
        }
        if (arg.attrTemplate != null) {
            this.attrTemplate = new QAsnOTNPortAttrTemplate(arg.attrTemplate);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.userID));
        this.portIndexList.serialize(enc);
        enc.serializeInteger(BigInteger.valueOf(this.qryType));
        if (this.levelList != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            this.levelList.serialize(enc);
        }
        if (this.attrTemplate != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            this.attrTemplate.serialize(enc);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.userID = bi.intValue();
        }
        this.portIndexList.deserialize(dec);
        bi = dec.deserializeInteger();
        if (null != bi) {
            this.qryType = bi.intValue();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.levelList = new QAsnLayerRateList();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.levelList.deserialize(dec);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            this.attrTemplate = new QAsnOTNPortAttrTemplate();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.attrTemplate.deserialize(dec);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("userID = ");
        os.print(this.userID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("portIndexList = ");
        this.portIndexList.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("qryType = ");
        os.print(this.qryType);
        os.println(',');
        if (this.levelList != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("levelList = ");
            this.levelList.print(os, indent + 2);
            os.println(',');
        }
        if (this.attrTemplate != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("attrTemplate = ");
            this.attrTemplate.print(os, indent + 2);
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

