/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_inventory_ne;

import com.huawei.network.qasn.m_q_common.QAsnSingleReturn;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnSNMPStreamInfo
implements FStruct {
    public int requestID = -1;
    public byte[] snmpStream;
    public QAsnSingleReturn poReturn = null;

    public QAsnSNMPStreamInfo() {
    }

    public QAsnSNMPStreamInfo(QAsnSNMPStreamInfo arg) {
        this.requestID = arg.requestID;
        this.snmpStream = new byte[arg.snmpStream.length];
        System.arraycopy(arg.snmpStream, 0, this.snmpStream, 0, arg.snmpStream.length);
        if (arg.poReturn != null) {
            this.poReturn = new QAsnSingleReturn(arg.poReturn);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.requestID));
        enc.serializeOctetString(this.snmpStream);
        if (this.poReturn != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            this.poReturn.serialize(enc);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.requestID = bi.intValue();
        }
        this.snmpStream = dec.deserializeOctetString();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.poReturn = new QAsnSingleReturn();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.poReturn.deserialize(dec);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("requestID = ");
        os.print(this.requestID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("snmpStream = ");
        os.print(FStruFormat.convertToString((byte[])this.snmpStream));
        os.println(',');
        if (this.poReturn != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poReturn = ");
            this.poReturn.print(os, indent + 2);
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

