/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_inventory_ne;

import com.huawei.network.qasn.m_q_common.QAsnNVSList;
import com.huawei.network.qasn.m_q_common.QAsnSingleReturn;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnPTNTransNEInfo
implements FStruct {
    public int neID = -1;
    public int phyID = -1;
    public int extID = -1;
    public byte[] strGNEFDN = null;
    public byte[] strIP = null;
    public QAsnNVSList poExAttrList = null;
    public QAsnSingleReturn poReturn = null;

    public QAsnPTNTransNEInfo() {
    }

    public QAsnPTNTransNEInfo(QAsnPTNTransNEInfo arg) {
        this.neID = arg.neID;
        this.phyID = arg.phyID;
        this.extID = arg.extID;
        if (arg.strGNEFDN != null) {
            this.strGNEFDN = new byte[arg.strGNEFDN.length];
            System.arraycopy(arg.strGNEFDN, 0, this.strGNEFDN, 0, arg.strGNEFDN.length);
        }
        if (arg.strIP != null) {
            this.strIP = new byte[arg.strIP.length];
            System.arraycopy(arg.strIP, 0, this.strIP, 0, arg.strIP.length);
        }
        if (arg.poExAttrList != null) {
            this.poExAttrList = new QAsnNVSList(arg.poExAttrList);
        }
        if (arg.poReturn != null) {
            this.poReturn = new QAsnSingleReturn(arg.poReturn);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.neID));
        enc.serializeInteger(BigInteger.valueOf(this.phyID));
        enc.serializeInteger(BigInteger.valueOf(this.extID));
        if (this.strGNEFDN != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.strGNEFDN);
        }
        if (this.strIP != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeOctetString(this.strIP);
        }
        if (this.poExAttrList != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)2));
            this.poExAttrList.serialize(enc);
        }
        if (this.poReturn != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)3));
            this.poReturn.serialize(enc);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.neID = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.phyID = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.extID = bi.intValue();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.strGNEFDN = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.strIP = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            this.poExAttrList = new QAsnNVSList();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)2));
            this.poExAttrList.deserialize(dec);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)3))) {
            this.poReturn = new QAsnSingleReturn();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)3));
            this.poReturn.deserialize(dec);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("neID = ");
        os.print(this.neID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("phyID = ");
        os.print(this.phyID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("extID = ");
        os.print(this.extID);
        os.println(',');
        if (this.strGNEFDN != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strGNEFDN = ");
            os.print(FStruFormat.convertToString((byte[])this.strGNEFDN));
            os.println(',');
        }
        if (this.strIP != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strIP = ");
            os.print(FStruFormat.convertToString((byte[])this.strIP));
            os.println(',');
        }
        if (this.poExAttrList != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poExAttrList = ");
            this.poExAttrList.print(os, indent + 2);
            os.println(',');
        }
        if (this.poReturn != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poReturn = ");
            this.poReturn.print(os, indent + 2);
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

