/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_inventory_ne;

import com.huawei.network.qasn.m_q_common.QAsnNEIDList;
import com.huawei.network.qasn.m_q_common.QAsnNVSList;
import com.huawei.network.qasn.m_q_common.QAsnTinyIntList;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnNEInfo
implements FStruct {
    public int emsID = -1;
    public int oneID = -1;
    public int neID = -1;
    public int phyID = -1;
    public int neType = -1;
    public int shelfType = -1;
    public byte[] name;
    public byte[] version = null;
    public Integer preconfig = null;
    public Integer configState = null;
    public byte[] memo = null;
    public byte[] location = null;
    public byte[] vendor = null;
    public byte[] address = null;
    public QAsnNEIDList gatewayNeList = null;
    public QAsnTinyIntList domainList = null;
    public byte[] userLabel = null;
    public byte[] owner = null;
    public QAsnNVSList exAttribList = null;

    public QAsnNEInfo() {
    }

    public QAsnNEInfo(QAsnNEInfo arg) {
        this.emsID = arg.emsID;
        this.oneID = arg.oneID;
        this.neID = arg.neID;
        this.phyID = arg.phyID;
        this.neType = arg.neType;
        this.shelfType = arg.shelfType;
        this.name = new byte[arg.name.length];
        System.arraycopy(arg.name, 0, this.name, 0, arg.name.length);
        if (arg.version != null) {
            this.version = new byte[arg.version.length];
            System.arraycopy(arg.version, 0, this.version, 0, arg.version.length);
        }
        if (arg.preconfig != null) {
            this.preconfig = arg.preconfig;
        }
        if (arg.configState != null) {
            this.configState = arg.configState;
        }
        if (arg.memo != null) {
            this.memo = new byte[arg.memo.length];
            System.arraycopy(arg.memo, 0, this.memo, 0, arg.memo.length);
        }
        if (arg.location != null) {
            this.location = new byte[arg.location.length];
            System.arraycopy(arg.location, 0, this.location, 0, arg.location.length);
        }
        if (arg.vendor != null) {
            this.vendor = new byte[arg.vendor.length];
            System.arraycopy(arg.vendor, 0, this.vendor, 0, arg.vendor.length);
        }
        if (arg.address != null) {
            this.address = new byte[arg.address.length];
            System.arraycopy(arg.address, 0, this.address, 0, arg.address.length);
        }
        if (arg.gatewayNeList != null) {
            this.gatewayNeList = new QAsnNEIDList(arg.gatewayNeList);
        }
        if (arg.domainList != null) {
            this.domainList = new QAsnTinyIntList(arg.domainList);
        }
        if (arg.userLabel != null) {
            this.userLabel = new byte[arg.userLabel.length];
            System.arraycopy(arg.userLabel, 0, this.userLabel, 0, arg.userLabel.length);
        }
        if (arg.owner != null) {
            this.owner = new byte[arg.owner.length];
            System.arraycopy(arg.owner, 0, this.owner, 0, arg.owner.length);
        }
        if (arg.exAttribList != null) {
            this.exAttribList = new QAsnNVSList(arg.exAttribList);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.emsID));
        enc.serializeInteger(BigInteger.valueOf(this.oneID));
        enc.serializeInteger(BigInteger.valueOf(this.neID));
        enc.serializeInteger(BigInteger.valueOf(this.phyID));
        enc.serializeInteger(BigInteger.valueOf(this.neType));
        enc.serializeInteger(BigInteger.valueOf(this.shelfType));
        enc.serializeOctetString(this.name);
        if (this.version != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.version);
        }
        if (this.preconfig != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeInteger(BigInteger.valueOf(this.preconfig.intValue()));
        }
        if (this.configState != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)2));
            enc.serializeInteger(BigInteger.valueOf(this.configState.intValue()));
        }
        if (this.memo != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)3));
            enc.serializeOctetString(this.memo);
        }
        if (this.location != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)4));
            enc.serializeOctetString(this.location);
        }
        if (this.vendor != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)5));
            enc.serializeOctetString(this.vendor);
        }
        if (this.address != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)6));
            enc.serializeOctetString(this.address);
        }
        if (this.gatewayNeList != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)7));
            this.gatewayNeList.serialize(enc);
        }
        if (this.domainList != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)8));
            this.domainList.serialize(enc);
        }
        if (this.userLabel != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)9));
            enc.serializeOctetString(this.userLabel);
        }
        if (this.owner != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)10));
            enc.serializeOctetString(this.owner);
        }
        if (this.exAttribList != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)11));
            this.exAttribList.serialize(enc);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.emsID = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.oneID = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.neID = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.phyID = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.neType = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.shelfType = bi.intValue();
        }
        this.name = dec.deserializeOctetString();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.version = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            this.preconfig = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.preconfig = bi.intValue();
            }
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            this.configState = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)2));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.configState = bi.intValue();
            }
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)3))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)3));
            this.memo = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)4))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)4));
            this.location = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)5))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)5));
            this.vendor = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)6))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)6));
            this.address = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)7))) {
            this.gatewayNeList = new QAsnNEIDList();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)7));
            this.gatewayNeList.deserialize(dec);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)8))) {
            this.domainList = new QAsnTinyIntList();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)8));
            this.domainList.deserialize(dec);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)9))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)9));
            this.userLabel = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)10))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)10));
            this.owner = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)11))) {
            this.exAttribList = new QAsnNVSList();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)11));
            this.exAttribList.deserialize(dec);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("emsID = ");
        os.print(this.emsID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("oneID = ");
        os.print(this.oneID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("neID = ");
        os.print(this.neID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("phyID = ");
        os.print(this.phyID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("neType = ");
        os.print(this.neType);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("shelfType = ");
        os.print(this.shelfType);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("name = ");
        os.print(FStruFormat.convertToString((byte[])this.name));
        os.println(',');
        if (this.version != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("version = ");
            os.print(FStruFormat.convertToString((byte[])this.version));
            os.println(',');
        }
        if (this.preconfig != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("preconfig = ");
            os.print(this.preconfig.toString());
            os.println(',');
        }
        if (this.configState != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("configState = ");
            os.print(this.configState.toString());
            os.println(',');
        }
        if (this.memo != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("memo = ");
            os.print(FStruFormat.convertToString((byte[])this.memo));
            os.println(',');
        }
        if (this.location != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("location = ");
            os.print(FStruFormat.convertToString((byte[])this.location));
            os.println(',');
        }
        if (this.vendor != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("vendor = ");
            os.print(FStruFormat.convertToString((byte[])this.vendor));
            os.println(',');
        }
        if (this.address != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("address = ");
            os.print(FStruFormat.convertToString((byte[])this.address));
            os.println(',');
        }
        if (this.gatewayNeList != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("gatewayNeList = ");
            this.gatewayNeList.print(os, indent + 2);
            os.println(',');
        }
        if (this.domainList != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("domainList = ");
            this.domainList.print(os, indent + 2);
            os.println(',');
        }
        if (this.userLabel != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("userLabel = ");
            os.print(FStruFormat.convertToString((byte[])this.userLabel));
            os.println(',');
        }
        if (this.owner != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("owner = ");
            os.print(FStruFormat.convertToString((byte[])this.owner));
            os.println(',');
        }
        if (this.exAttribList != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("exAttribList = ");
            this.exAttribList.print(os, indent + 2);
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

