/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_inventory_ne;

import com.huawei.network.qasn.m_q_common.QAsnNVSList;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class QAsnClockAttr
implements FStruct {
    public int clockID = -1;
    public int timingMode = -1;
    public int quality = -1;
    public Integer workingMode = null;
    public QAsnNVSList nvLst = null;

    public QAsnClockAttr() {
    }

    public QAsnClockAttr(QAsnClockAttr arg) {
        this.clockID = arg.clockID;
        this.timingMode = arg.timingMode;
        this.quality = arg.quality;
        if (arg.workingMode != null) {
            this.workingMode = arg.workingMode;
        }
        if (arg.nvLst != null) {
            this.nvLst = new QAsnNVSList(arg.nvLst);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.clockID));
        enc.serializeInteger(BigInteger.valueOf(this.timingMode));
        enc.serializeInteger(BigInteger.valueOf(this.quality));
        if (this.workingMode != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(BigInteger.valueOf(this.workingMode.intValue()));
        }
        if (this.nvLst != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            this.nvLst.serialize(enc);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.clockID = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.timingMode = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.quality = bi.intValue();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.workingMode = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.workingMode = bi.intValue();
            }
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            this.nvLst = new QAsnNVSList();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.nvLst.deserialize(dec);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("clockID = ");
        os.print(this.clockID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("timingMode = ");
        os.print(this.timingMode);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("quality = ");
        os.print(this.quality);
        os.println(',');
        if (this.workingMode != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("workingMode = ");
            os.print(this.workingMode.toString());
            os.println(',');
        }
        if (this.nvLst != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("nvLst = ");
            this.nvLst.print(os, indent + 2);
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

