/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_inventory_link_ne;

import com.huawei.network.qasn.m_q_common.QAsnPortIndex;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_inventory_link_ne.QAsnP2MPOption;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnSimpLinkStru
implements FStruct {
    public QAsnUniResID srcPort = new QAsnUniResID();
    public QAsnUniResID snkPort = new QAsnUniResID();
    public QAsnP2MPOption p2mpOption = null;
    public int operaType = -1;
    public int linkType = -1;
    public int linkSubType = -1;
    public Integer poServiceStatus = null;
    public QAsnPortIndex srcPortIndex = null;
    public QAsnPortIndex snkPortIndex = null;
    public byte[] srcMac = null;
    public byte[] snkMac = null;

    public QAsnSimpLinkStru() {
    }

    public QAsnSimpLinkStru(QAsnSimpLinkStru arg) {
        this.srcPort = new QAsnUniResID(arg.srcPort);
        this.snkPort = new QAsnUniResID(arg.snkPort);
        if (arg.p2mpOption != null) {
            this.p2mpOption = new QAsnP2MPOption(arg.p2mpOption);
        }
        this.operaType = arg.operaType;
        this.linkType = arg.linkType;
        this.linkSubType = arg.linkSubType;
        if (arg.poServiceStatus != null) {
            this.poServiceStatus = arg.poServiceStatus;
        }
        if (arg.srcPortIndex != null) {
            this.srcPortIndex = new QAsnPortIndex(arg.srcPortIndex);
        }
        if (arg.snkPortIndex != null) {
            this.snkPortIndex = new QAsnPortIndex(arg.snkPortIndex);
        }
        if (arg.srcMac != null) {
            this.srcMac = new byte[arg.srcMac.length];
            System.arraycopy(arg.srcMac, 0, this.srcMac, 0, arg.srcMac.length);
        }
        if (arg.snkMac != null) {
            this.snkMac = new byte[arg.snkMac.length];
            System.arraycopy(arg.snkMac, 0, this.snkMac, 0, arg.snkMac.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.srcPort.serialize(enc);
        this.snkPort.serialize(enc);
        if (this.p2mpOption != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            this.p2mpOption.serialize(enc);
        }
        enc.serializeInteger(BigInteger.valueOf(this.operaType));
        enc.serializeInteger(BigInteger.valueOf(this.linkType));
        enc.serializeInteger(BigInteger.valueOf(this.linkSubType));
        if (this.poServiceStatus != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeInteger(BigInteger.valueOf(this.poServiceStatus.intValue()));
        }
        if (this.srcPortIndex != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)2));
            this.srcPortIndex.serialize(enc);
        }
        if (this.snkPortIndex != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)3));
            this.snkPortIndex.serialize(enc);
        }
        if (this.srcMac != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)4));
            enc.serializeOctetString(this.srcMac);
        }
        if (this.snkMac != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)5));
            enc.serializeOctetString(this.snkMac);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        BigInteger bi;
        int seq_nr = dec.deserializeSequence();
        this.srcPort.deserialize(dec);
        this.snkPort.deserialize(dec);
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.p2mpOption = new QAsnP2MPOption();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.p2mpOption.deserialize(dec);
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.operaType = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.linkType = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.linkSubType = bi.intValue();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            this.poServiceStatus = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.poServiceStatus = bi.intValue();
            }
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            this.srcPortIndex = new QAsnPortIndex();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)2));
            this.srcPortIndex.deserialize(dec);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)3))) {
            this.snkPortIndex = new QAsnPortIndex();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)3));
            this.snkPortIndex.deserialize(dec);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)4))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)4));
            this.srcMac = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)5))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)5));
            this.snkMac = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("srcPort = ");
        this.srcPort.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("snkPort = ");
        this.snkPort.print(os, indent + 2);
        os.println(',');
        if (this.p2mpOption != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("p2mpOption = ");
            this.p2mpOption.print(os, indent + 2);
            os.println(',');
        }
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("operaType = ");
        os.print(this.operaType);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("linkType = ");
        os.print(this.linkType);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("linkSubType = ");
        os.print(this.linkSubType);
        os.println(',');
        if (this.poServiceStatus != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poServiceStatus = ");
            os.print(this.poServiceStatus.toString());
            os.println(',');
        }
        if (this.srcPortIndex != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("srcPortIndex = ");
            this.srcPortIndex.print(os, indent + 2);
            os.println(',');
        }
        if (this.snkPortIndex != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("snkPortIndex = ");
            this.snkPortIndex.print(os, indent + 2);
            os.println(',');
        }
        if (this.srcMac != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("srcMac = ");
            os.print(FStruFormat.convertToString((byte[])this.srcMac));
            os.println(',');
        }
        if (this.snkMac != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("snkMac = ");
            os.print(FStruFormat.convertToString((byte[])this.snkMac));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

