/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_inventory_link_ne;

import com.huawei.network.qasn.m_q_common.QAsnNVSList;
import com.huawei.network.qasn.m_q_common.QAsnPortIndex;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_inventory_link_ne.QAsnP2MPOption;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnDiscreteLinkStru
implements FStruct {
    public QAsnUniResID inDomainPort = new QAsnUniResID();
    public QAsnPortIndex outDomainPort = new QAsnPortIndex();
    public Integer outDomainPhyID = null;
    public byte[] outDomainIP = null;
    public int linkType = -1;
    public int linkSubType = -1;
    public QAsnP2MPOption p2mpOption = null;
    public Integer poServiceStatus = null;
    public QAsnNVSList nvList = null;

    public QAsnDiscreteLinkStru() {
    }

    public QAsnDiscreteLinkStru(QAsnDiscreteLinkStru arg) {
        this.inDomainPort = new QAsnUniResID(arg.inDomainPort);
        this.outDomainPort = new QAsnPortIndex(arg.outDomainPort);
        if (arg.outDomainPhyID != null) {
            this.outDomainPhyID = arg.outDomainPhyID;
        }
        if (arg.outDomainIP != null) {
            this.outDomainIP = new byte[arg.outDomainIP.length];
            System.arraycopy(arg.outDomainIP, 0, this.outDomainIP, 0, arg.outDomainIP.length);
        }
        this.linkType = arg.linkType;
        this.linkSubType = arg.linkSubType;
        if (arg.p2mpOption != null) {
            this.p2mpOption = new QAsnP2MPOption(arg.p2mpOption);
        }
        if (arg.poServiceStatus != null) {
            this.poServiceStatus = arg.poServiceStatus;
        }
        if (arg.nvList != null) {
            this.nvList = new QAsnNVSList(arg.nvList);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.inDomainPort.serialize(enc);
        this.outDomainPort.serialize(enc);
        if (this.outDomainPhyID != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(BigInteger.valueOf(this.outDomainPhyID.intValue()));
        }
        if (this.outDomainIP != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeOctetString(this.outDomainIP);
        }
        enc.serializeInteger(BigInteger.valueOf(this.linkType));
        enc.serializeInteger(BigInteger.valueOf(this.linkSubType));
        if (this.p2mpOption != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)2));
            this.p2mpOption.serialize(enc);
        }
        if (this.poServiceStatus != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)3));
            enc.serializeInteger(BigInteger.valueOf(this.poServiceStatus.intValue()));
        }
        if (this.nvList != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)4));
            this.nvList.serialize(enc);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        BigInteger bi;
        int seq_nr = dec.deserializeSequence();
        this.inDomainPort.deserialize(dec);
        this.outDomainPort.deserialize(dec);
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.outDomainPhyID = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.outDomainPhyID = bi.intValue();
            }
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.outDomainIP = dec.deserializeOctetString();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.linkType = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.linkSubType = bi.intValue();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            this.p2mpOption = new QAsnP2MPOption();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)2));
            this.p2mpOption.deserialize(dec);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)3))) {
            this.poServiceStatus = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)3));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.poServiceStatus = bi.intValue();
            }
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)4))) {
            this.nvList = new QAsnNVSList();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)4));
            this.nvList.deserialize(dec);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("inDomainPort = ");
        this.inDomainPort.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("outDomainPort = ");
        this.outDomainPort.print(os, indent + 2);
        os.println(',');
        if (this.outDomainPhyID != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("outDomainPhyID = ");
            os.print(this.outDomainPhyID.toString());
            os.println(',');
        }
        if (this.outDomainIP != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("outDomainIP = ");
            os.print(FStruFormat.convertToString((byte[])this.outDomainIP));
            os.println(',');
        }
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("linkType = ");
        os.print(this.linkType);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("linkSubType = ");
        os.print(this.linkSubType);
        os.println(',');
        if (this.p2mpOption != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("p2mpOption = ");
            this.p2mpOption.print(os, indent + 2);
            os.println(',');
        }
        if (this.poServiceStatus != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poServiceStatus = ");
            os.print(this.poServiceStatus.toString());
            os.println(',');
        }
        if (this.nvList != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("nvList = ");
            this.nvList.print(os, indent + 2);
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

