/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_inventory_fiber;

import com.huawei.network.qasn.m_q_common.QAsnPortIndex;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class QAsnSimpFiberStru
implements FStruct {
    public QAsnPortIndex srcPort = new QAsnPortIndex();
    public QAsnPortIndex snkPort = new QAsnPortIndex();
    public int direct = -1;
    public boolean isIFLink;

    public QAsnSimpFiberStru() {
    }

    public QAsnSimpFiberStru(QAsnSimpFiberStru arg) {
        this.srcPort = new QAsnPortIndex(arg.srcPort);
        this.snkPort = new QAsnPortIndex(arg.snkPort);
        this.direct = arg.direct;
        this.isIFLink = arg.isIFLink;
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.srcPort.serialize(enc);
        this.snkPort.serialize(enc);
        enc.serializeInteger(BigInteger.valueOf(this.direct));
        enc.serializeBoolean(this.isIFLink);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.srcPort.deserialize(dec);
        this.snkPort.deserialize(dec);
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.direct = bi.intValue();
        }
        this.isIFLink = dec.deserializeBoolean();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("srcPort = ");
        this.srcPort.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("snkPort = ");
        this.snkPort.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("direct = ");
        os.print(this.direct);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("isIFLink = ");
        os.print(this.isIFLink);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

