/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_inventory_fiber;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnFiberErrorCode
implements FStruct {
    public BigInteger fiberID;
    public byte[] objectName;
    public BigInteger errPos;
    public BigInteger eolError = null;

    public QAsnFiberErrorCode() {
    }

    public QAsnFiberErrorCode(QAsnFiberErrorCode arg) {
        this.fiberID = arg.fiberID;
        this.objectName = new byte[arg.objectName.length];
        System.arraycopy(arg.objectName, 0, this.objectName, 0, arg.objectName.length);
        this.errPos = arg.errPos;
        if (arg.eolError != null) {
            this.eolError = arg.eolError;
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.fiberID);
        enc.serializeOctetString(this.objectName);
        enc.serializeInteger(this.errPos);
        if (this.eolError != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(this.eolError);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.fiberID = dec.deserializeInteger();
        this.objectName = dec.deserializeOctetString();
        this.errPos = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.eolError = dec.deserializeInteger();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("fiberID = ");
        os.print(this.fiberID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("objectName = ");
        os.print(FStruFormat.convertToString((byte[])this.objectName));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("errPos = ");
        os.print(this.errPos.toString());
        os.println(',');
        if (this.eolError != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("eolError = ");
            os.print(this.eolError.toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

