/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_inventory_fiber;

import com.huawei.network.qasn.m_q_common.QAsnNVSList;
import com.huawei.network.qasn.m_q_inventory_fiber.AsnNetPortIndex;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnFiberInfo
implements FStruct {
    public byte[] fiberUniqueID;
    public byte[] name;
    public BigInteger type;
    public BigInteger direction;
    public AsnNetPortIndex srcPort = new AsnNetPortIndex();
    public AsnNetPortIndex snkPort = new AsnNetPortIndex();
    public BigInteger level = null;
    public byte[] userLabel = null;
    public byte[] owner = null;
    public QAsnNVSList exAttribList = null;

    public AsnFiberInfo() {
    }

    public AsnFiberInfo(AsnFiberInfo arg) {
        this.fiberUniqueID = new byte[arg.fiberUniqueID.length];
        System.arraycopy(arg.fiberUniqueID, 0, this.fiberUniqueID, 0, arg.fiberUniqueID.length);
        this.name = new byte[arg.name.length];
        System.arraycopy(arg.name, 0, this.name, 0, arg.name.length);
        this.type = arg.type;
        this.direction = arg.direction;
        this.srcPort = new AsnNetPortIndex(arg.srcPort);
        this.snkPort = new AsnNetPortIndex(arg.snkPort);
        if (arg.level != null) {
            this.level = arg.level;
        }
        if (arg.userLabel != null) {
            this.userLabel = new byte[arg.userLabel.length];
            System.arraycopy(arg.userLabel, 0, this.userLabel, 0, arg.userLabel.length);
        }
        if (arg.owner != null) {
            this.owner = new byte[arg.owner.length];
            System.arraycopy(arg.owner, 0, this.owner, 0, arg.owner.length);
        }
        if (arg.exAttribList != null) {
            this.exAttribList = new QAsnNVSList(arg.exAttribList);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.fiberUniqueID);
        enc.serializeOctetString(this.name);
        enc.serializeInteger(this.type);
        enc.serializeInteger(this.direction);
        this.srcPort.serialize(enc);
        this.snkPort.serialize(enc);
        if (this.level != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(this.level);
        }
        if (this.userLabel != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeOctetString(this.userLabel);
        }
        if (this.owner != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)2));
            enc.serializeOctetString(this.owner);
        }
        if (this.exAttribList != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)3));
            this.exAttribList.serialize(enc);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.fiberUniqueID = dec.deserializeOctetString();
        this.name = dec.deserializeOctetString();
        this.type = dec.deserializeInteger();
        this.direction = dec.deserializeInteger();
        this.srcPort.deserialize(dec);
        this.snkPort.deserialize(dec);
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.level = dec.deserializeInteger();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.userLabel = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)2));
            this.owner = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)3))) {
            this.exAttribList = new QAsnNVSList();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)3));
            this.exAttribList.deserialize(dec);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("fiberUniqueID = ");
        os.print(FStruFormat.convertToString((byte[])this.fiberUniqueID));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("name = ");
        os.print(FStruFormat.convertToString((byte[])this.name));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("type = ");
        os.print(this.type.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("direction = ");
        os.print(this.direction.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("srcPort = ");
        this.srcPort.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("snkPort = ");
        this.snkPort.print(os, indent + 2);
        os.println(',');
        if (this.level != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("level = ");
            os.print(this.level.toString());
            os.println(',');
        }
        if (this.userLabel != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("userLabel = ");
            os.print(FStruFormat.convertToString((byte[])this.userLabel));
            os.println(',');
        }
        if (this.owner != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("owner = ");
            os.print(FStruFormat.convertToString((byte[])this.owner));
            os.println(',');
        }
        if (this.exAttribList != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("exAttribList = ");
            this.exAttribList.print(os, indent + 2);
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

