/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_inventory_cp;

import com.huawei.network.qasn.m_q_common.QAsnCPIndex;
import com.huawei.network.qasn.m_q_common.QAsnNVSList;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnDelCPRpt
implements FStruct {
    public int userID = -1;
    public int emsId = -1;
    public QAsnCPIndex cpIndex = new QAsnCPIndex();
    public byte[] taskFlag = null;
    public QAsnNVSList exAttribList = null;

    public QAsnDelCPRpt() {
    }

    public QAsnDelCPRpt(QAsnDelCPRpt arg) {
        this.userID = arg.userID;
        this.emsId = arg.emsId;
        this.cpIndex = new QAsnCPIndex(arg.cpIndex);
        if (arg.taskFlag != null) {
            this.taskFlag = new byte[arg.taskFlag.length];
            System.arraycopy(arg.taskFlag, 0, this.taskFlag, 0, arg.taskFlag.length);
        }
        if (arg.exAttribList != null) {
            this.exAttribList = new QAsnNVSList(arg.exAttribList);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.userID));
        enc.serializeInteger(BigInteger.valueOf(this.emsId));
        this.cpIndex.serialize(enc);
        if (this.taskFlag != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.taskFlag);
        }
        if (this.exAttribList != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            this.exAttribList.serialize(enc);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.userID = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.emsId = bi.intValue();
        }
        this.cpIndex.deserialize(dec);
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.taskFlag = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            this.exAttribList = new QAsnNVSList();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.exAttribList.deserialize(dec);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("userID = ");
        os.print(this.userID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("emsId = ");
        os.print(this.emsId);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("cpIndex = ");
        this.cpIndex.print(os, indent + 2);
        os.println(',');
        if (this.taskFlag != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("taskFlag = ");
            os.print(FStruFormat.convertToString((byte[])this.taskFlag));
            os.println(',');
        }
        if (this.exAttribList != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("exAttribList = ");
            this.exAttribList.print(os, indent + 2);
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

