/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_inventory_cp;

import com.huawei.network.qasn.m_q_common.QAsnTinyIntList;
import com.huawei.network.qasn.m_q_inventory_cp.QAsnStaticPortInfoList;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnCPStaticInfo
implements FStruct {
    public byte[] name;
    public int type = -1;
    public QAsnTinyIntList cptypelist = null;
    public QAsnStaticPortInfoList portinfolist = null;

    public QAsnCPStaticInfo() {
    }

    public QAsnCPStaticInfo(QAsnCPStaticInfo arg) {
        this.name = new byte[arg.name.length];
        System.arraycopy(arg.name, 0, this.name, 0, arg.name.length);
        this.type = arg.type;
        if (arg.cptypelist != null) {
            this.cptypelist = new QAsnTinyIntList(arg.cptypelist);
        }
        if (arg.portinfolist != null) {
            this.portinfolist = new QAsnStaticPortInfoList(arg.portinfolist);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.name);
        enc.serializeInteger(BigInteger.valueOf(this.type));
        if (this.cptypelist != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            this.cptypelist.serialize(enc);
        }
        if (this.portinfolist != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            this.portinfolist.serialize(enc);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.name = dec.deserializeOctetString();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.type = bi.intValue();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.cptypelist = new QAsnTinyIntList();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.cptypelist.deserialize(dec);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            this.portinfolist = new QAsnStaticPortInfoList();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.portinfolist.deserialize(dec);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("name = ");
        os.print(FStruFormat.convertToString((byte[])this.name));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("type = ");
        os.print(this.type);
        os.println(',');
        if (this.cptypelist != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("cptypelist = ");
            this.cptypelist.print(os, indent + 2);
            os.println(',');
        }
        if (this.portinfolist != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("portinfolist = ");
            this.portinfolist.print(os, indent + 2);
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

