/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_inventory_cp;

import com.huawei.network.qasn.m_q_common.QAsnCPIndex;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class QAsnCPState
implements FStruct {
    public QAsnCPIndex cpIndex = new QAsnCPIndex();
    public int workState = -1;
    public int operState = -1;
    public Integer administrativeState = null;

    public QAsnCPState() {
    }

    public QAsnCPState(QAsnCPState arg) {
        this.cpIndex = new QAsnCPIndex(arg.cpIndex);
        this.workState = arg.workState;
        this.operState = arg.operState;
        if (arg.administrativeState != null) {
            this.administrativeState = arg.administrativeState;
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.cpIndex.serialize(enc);
        enc.serializeInteger(BigInteger.valueOf(this.workState));
        enc.serializeInteger(BigInteger.valueOf(this.operState));
        if (this.administrativeState != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(BigInteger.valueOf(this.administrativeState.intValue()));
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.cpIndex.deserialize(dec);
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.workState = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.operState = bi.intValue();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.administrativeState = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.administrativeState = bi.intValue();
            }
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("cpIndex = ");
        this.cpIndex.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("workState = ");
        os.print(this.workState);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("operState = ");
        os.print(this.operState);
        os.println(',');
        if (this.administrativeState != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("administrativeState = ");
            os.print(this.administrativeState.toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

