/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_interface_model;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnPortAndIPAddr
implements FStruct {
    public QAsnUniResID objectID = new QAsnUniResID();
    public int portType = -1;
    public byte[] ipAddress;

    public QAsnPortAndIPAddr() {
    }

    public QAsnPortAndIPAddr(QAsnPortAndIPAddr arg) {
        this.objectID = new QAsnUniResID(arg.objectID);
        this.portType = arg.portType;
        this.ipAddress = new byte[arg.ipAddress.length];
        System.arraycopy(arg.ipAddress, 0, this.ipAddress, 0, arg.ipAddress.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.objectID.serialize(enc);
        enc.serializeInteger(BigInteger.valueOf(this.portType));
        enc.serializeOctetString(this.ipAddress);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.objectID.deserialize(dec);
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.portType = bi.intValue();
        }
        this.ipAddress = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("objectID = ");
        this.objectID.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("portType = ");
        os.print(this.portType);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("ipAddress = ");
        os.print(FStruFormat.convertToString((byte[])this.ipAddress));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

