/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_interface_model;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnL2TunelPkt
implements FStruct {
    public byte[] protocolType;
    public int iOperType = -1;

    public QAsnL2TunelPkt() {
    }

    public QAsnL2TunelPkt(QAsnL2TunelPkt arg) {
        this.protocolType = new byte[arg.protocolType.length];
        System.arraycopy(arg.protocolType, 0, this.protocolType, 0, arg.protocolType.length);
        this.iOperType = arg.iOperType;
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.protocolType);
        enc.serializeInteger(BigInteger.valueOf(this.iOperType));
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.protocolType = dec.deserializeOctetString();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.iOperType = bi.intValue();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("protocolType = ");
        os.print(FStruFormat.convertToString((byte[])this.protocolType));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iOperType = ");
        os.print(this.iOperType);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

