/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnUniResID
implements FStruct {
    public byte[] strFDN;
    public byte[] strMOC;
    public int neID = -1;
    public byte[] poSerialNum = null;

    public QAsnUniResID() {
    }

    public QAsnUniResID(QAsnUniResID arg) {
        this.strFDN = new byte[arg.strFDN.length];
        System.arraycopy(arg.strFDN, 0, this.strFDN, 0, arg.strFDN.length);
        this.strMOC = new byte[arg.strMOC.length];
        System.arraycopy(arg.strMOC, 0, this.strMOC, 0, arg.strMOC.length);
        this.neID = arg.neID;
        if (arg.poSerialNum != null) {
            this.poSerialNum = new byte[arg.poSerialNum.length];
            System.arraycopy(arg.poSerialNum, 0, this.poSerialNum, 0, arg.poSerialNum.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.strFDN);
        enc.serializeOctetString(this.strMOC);
        enc.serializeInteger(BigInteger.valueOf(this.neID));
        if (this.poSerialNum != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.poSerialNum);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.strFDN = dec.deserializeOctetString();
        this.strMOC = dec.deserializeOctetString();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.neID = bi.intValue();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.poSerialNum = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strFDN = ");
        os.print(FStruFormat.convertToString((byte[])this.strFDN));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strMOC = ");
        os.print(FStruFormat.convertToString((byte[])this.strMOC));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("neID = ");
        os.print(this.neID);
        os.println(',');
        if (this.poSerialNum != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poSerialNum = ");
            os.print(FStruFormat.convertToString((byte[])this.poSerialNum));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

