/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnIPV6Address
implements FStruct {
    public byte[] address;
    public int prefixLength = -1;
    public int scopeType = -1;
    public int addressType = -1;
    public int anycastFlag = -1;
    public int addressStatus = -1;
    public Integer poOperMask = null;

    public QAsnIPV6Address() {
    }

    public QAsnIPV6Address(QAsnIPV6Address arg) {
        this.address = new byte[arg.address.length];
        System.arraycopy(arg.address, 0, this.address, 0, arg.address.length);
        this.prefixLength = arg.prefixLength;
        this.scopeType = arg.scopeType;
        this.addressType = arg.addressType;
        this.anycastFlag = arg.anycastFlag;
        this.addressStatus = arg.addressStatus;
        if (arg.poOperMask != null) {
            this.poOperMask = arg.poOperMask;
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.address);
        enc.serializeInteger(BigInteger.valueOf(this.prefixLength));
        enc.serializeInteger(BigInteger.valueOf(this.scopeType));
        enc.serializeInteger(BigInteger.valueOf(this.addressType));
        enc.serializeInteger(BigInteger.valueOf(this.anycastFlag));
        enc.serializeInteger(BigInteger.valueOf(this.addressStatus));
        if (this.poOperMask != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(BigInteger.valueOf(this.poOperMask.intValue()));
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.address = dec.deserializeOctetString();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.prefixLength = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.scopeType = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.addressType = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.anycastFlag = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.addressStatus = bi.intValue();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.poOperMask = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.poOperMask = bi.intValue();
            }
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("address = ");
        os.print(FStruFormat.convertToString((byte[])this.address));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("prefixLength = ");
        os.print(this.prefixLength);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("scopeType = ");
        os.print(this.scopeType);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("addressType = ");
        os.print(this.addressType);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("anycastFlag = ");
        os.print(this.anycastFlag);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("addressStatus = ");
        os.print(this.addressStatus);
        os.println(',');
        if (this.poOperMask != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poOperMask = ");
            os.print(this.poOperMask.toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

