/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnIPAddress
implements FStruct {
    public byte[] address;
    public byte[] mask;
    public int isMaster = -1;

    public QAsnIPAddress() {
    }

    public QAsnIPAddress(QAsnIPAddress arg) {
        this.address = new byte[arg.address.length];
        System.arraycopy(arg.address, 0, this.address, 0, arg.address.length);
        this.mask = new byte[arg.mask.length];
        System.arraycopy(arg.mask, 0, this.mask, 0, arg.mask.length);
        this.isMaster = arg.isMaster;
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.address);
        enc.serializeOctetString(this.mask);
        enc.serializeInteger(BigInteger.valueOf(this.isMaster));
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.address = dec.deserializeOctetString();
        this.mask = dec.deserializeOctetString();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.isMaster = bi.intValue();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("address = ");
        os.print(FStruFormat.convertToString((byte[])this.address));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("mask = ");
        os.print(FStruFormat.convertToString((byte[])this.mask));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("isMaster = ");
        os.print(this.isMaster);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

