/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.dcgetprotocolparam;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnDevProperties
implements FStruct {
    public int iDevID = -1;
    public BigInteger iDevProtocol;
    public byte[] strUserName;
    public byte[] strPassword;
    public byte[] strUserPrivateKey;
    public BigInteger iPort;
    public BigInteger iAuthMode;
    public BigInteger iPrivilegeLevel;
    public byte[] iPrivilegePwd;
    public BigInteger iLoginTimeout;
    public BigInteger iResponseTimeout;
    public BigInteger iProtocolVersion;
    public BigInteger iEnableFlag;
    public byte[] strUserPrivateKeyPwd;

    public AsnDevProperties() {
    }

    public AsnDevProperties(AsnDevProperties arg) {
        this.iDevID = arg.iDevID;
        this.iDevProtocol = arg.iDevProtocol;
        this.strUserName = new byte[arg.strUserName.length];
        System.arraycopy(arg.strUserName, 0, this.strUserName, 0, arg.strUserName.length);
        this.strPassword = new byte[arg.strPassword.length];
        System.arraycopy(arg.strPassword, 0, this.strPassword, 0, arg.strPassword.length);
        this.strUserPrivateKey = new byte[arg.strUserPrivateKey.length];
        System.arraycopy(arg.strUserPrivateKey, 0, this.strUserPrivateKey, 0, arg.strUserPrivateKey.length);
        this.iPort = arg.iPort;
        this.iAuthMode = arg.iAuthMode;
        this.iPrivilegeLevel = arg.iPrivilegeLevel;
        this.iPrivilegePwd = new byte[arg.iPrivilegePwd.length];
        System.arraycopy(arg.iPrivilegePwd, 0, this.iPrivilegePwd, 0, arg.iPrivilegePwd.length);
        this.iLoginTimeout = arg.iLoginTimeout;
        this.iResponseTimeout = arg.iResponseTimeout;
        this.iProtocolVersion = arg.iProtocolVersion;
        this.iEnableFlag = arg.iEnableFlag;
        this.strUserPrivateKeyPwd = new byte[arg.strUserPrivateKeyPwd.length];
        System.arraycopy(arg.strUserPrivateKeyPwd, 0, this.strUserPrivateKeyPwd, 0, arg.strUserPrivateKeyPwd.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.iDevID));
        enc.serializeInteger(this.iDevProtocol);
        enc.serializeOctetString(this.strUserName);
        enc.serializeOctetString(this.strPassword);
        enc.serializeOctetString(this.strUserPrivateKey);
        enc.serializeInteger(this.iPort);
        enc.serializeInteger(this.iAuthMode);
        enc.serializeInteger(this.iPrivilegeLevel);
        enc.serializeOctetString(this.iPrivilegePwd);
        enc.serializeInteger(this.iLoginTimeout);
        enc.serializeInteger(this.iResponseTimeout);
        enc.serializeInteger(this.iProtocolVersion);
        enc.serializeInteger(this.iEnableFlag);
        enc.serializeOctetString(this.strUserPrivateKeyPwd);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.iDevID = bi.intValue();
        }
        this.iDevProtocol = dec.deserializeInteger();
        this.strUserName = dec.deserializeOctetString();
        this.strPassword = dec.deserializeOctetString();
        this.strUserPrivateKey = dec.deserializeOctetString();
        this.iPort = dec.deserializeInteger();
        this.iAuthMode = dec.deserializeInteger();
        this.iPrivilegeLevel = dec.deserializeInteger();
        this.iPrivilegePwd = dec.deserializeOctetString();
        this.iLoginTimeout = dec.deserializeInteger();
        this.iResponseTimeout = dec.deserializeInteger();
        this.iProtocolVersion = dec.deserializeInteger();
        this.iEnableFlag = dec.deserializeInteger();
        this.strUserPrivateKeyPwd = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iDevID = ");
        os.print(this.iDevID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iDevProtocol = ");
        os.print(this.iDevProtocol.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strUserName = ");
        os.print(FStruFormat.convertToString((byte[])this.strUserName));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strPassword = ");
        os.print(FStruFormat.convertToString((byte[])this.strPassword));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strUserPrivateKey = ");
        os.print(FStruFormat.convertToString((byte[])this.strUserPrivateKey));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iPort = ");
        os.print(this.iPort.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iAuthMode = ");
        os.print(this.iAuthMode.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iPrivilegeLevel = ");
        os.print(this.iPrivilegeLevel.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iPrivilegePwd = ");
        os.print(FStruFormat.convertToString((byte[])this.iPrivilegePwd));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iLoginTimeout = ");
        os.print(this.iLoginTimeout.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iResponseTimeout = ");
        os.print(this.iResponseTimeout.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iProtocolVersion = ");
        os.print(this.iProtocolVersion.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iEnableFlag = ");
        os.print(this.iEnableFlag.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strUserPrivateKeyPwd = ");
        os.print(FStruFormat.convertToString((byte[])this.strUserPrivateKeyPwd));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

