/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.asnutil;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnXmlExportResult
implements FStruct {
    public BigInteger neID;
    public byte[] cfgItem;
    public BigInteger errorCode;
    public byte[] detail;

    public AsnXmlExportResult() {
    }

    public AsnXmlExportResult(AsnXmlExportResult arg) {
        this.neID = arg.neID;
        this.cfgItem = new byte[arg.cfgItem.length];
        System.arraycopy(arg.cfgItem, 0, this.cfgItem, 0, arg.cfgItem.length);
        this.errorCode = arg.errorCode;
        this.detail = new byte[arg.detail.length];
        System.arraycopy(arg.detail, 0, this.detail, 0, arg.detail.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.neID);
        enc.serializeOctetString(this.cfgItem);
        enc.serializeInteger(this.errorCode);
        enc.serializeOctetString(this.detail);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.neID = dec.deserializeInteger();
        this.cfgItem = dec.deserializeOctetString();
        this.errorCode = dec.deserializeInteger();
        this.detail = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("neID = ");
        os.print(this.neID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("cfgItem = ");
        os.print(FStruFormat.convertToString((byte[])this.cfgItem));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("errorCode = ");
        os.print(this.errorCode.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("detail = ");
        os.print(FStruFormat.convertToString((byte[])this.detail));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

