/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.asnutil;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnTestCmdReq
implements FStruct {
    public BigInteger taskmgrID;
    public BigInteger cmdCode;
    public byte[] asnReq;

    public AsnTestCmdReq() {
    }

    public AsnTestCmdReq(AsnTestCmdReq arg) {
        this.taskmgrID = arg.taskmgrID;
        this.cmdCode = arg.cmdCode;
        this.asnReq = new byte[arg.asnReq.length];
        System.arraycopy(arg.asnReq, 0, this.asnReq, 0, arg.asnReq.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.taskmgrID);
        enc.serializeInteger(this.cmdCode);
        enc.serializeOctetString(this.asnReq);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.taskmgrID = dec.deserializeInteger();
        this.cmdCode = dec.deserializeInteger();
        this.asnReq = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("taskmgrID = ");
        os.print(this.taskmgrID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("cmdCode = ");
        os.print(this.cmdCode.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("asnReq = ");
        os.print(FStruFormat.convertToString((byte[])this.asnReq));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

