/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.asnutil;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnSingleOperationResult
implements FStruct {
    public BigInteger neID;
    public BigInteger cfgItem;
    public byte[] cfgItemName;
    public BigInteger errorCode;

    public AsnSingleOperationResult() {
    }

    public AsnSingleOperationResult(AsnSingleOperationResult arg) {
        this.neID = arg.neID;
        this.cfgItem = arg.cfgItem;
        this.cfgItemName = new byte[arg.cfgItemName.length];
        System.arraycopy(arg.cfgItemName, 0, this.cfgItemName, 0, arg.cfgItemName.length);
        this.errorCode = arg.errorCode;
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.neID);
        enc.serializeInteger(this.cfgItem);
        enc.serializeOctetString(this.cfgItemName);
        enc.serializeInteger(this.errorCode);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.neID = dec.deserializeInteger();
        this.cfgItem = dec.deserializeInteger();
        this.cfgItemName = dec.deserializeOctetString();
        this.errorCode = dec.deserializeInteger();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("neID = ");
        os.print(this.neID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("cfgItem = ");
        os.print(this.cfgItem.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("cfgItemName = ");
        os.print(FStruFormat.convertToString((byte[])this.cfgItemName));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("errorCode = ");
        os.print(this.errorCode.toString());
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

