/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.asnutil;

import com.huawei.network.qasn.asnutil.AsnStrList;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class AsnReloadReq
implements FStruct {
    public BigInteger userID;
    public BigInteger procID;
    public BigInteger procHandle;
    public BigInteger loadType;
    public AsnStrList moduleList = new AsnStrList();

    public AsnReloadReq() {
    }

    public AsnReloadReq(AsnReloadReq arg) {
        this.userID = arg.userID;
        this.procID = arg.procID;
        this.procHandle = arg.procHandle;
        this.loadType = arg.loadType;
        this.moduleList = new AsnStrList(arg.moduleList);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.userID);
        enc.serializeInteger(this.procID);
        enc.serializeInteger(this.procHandle);
        enc.serializeInteger(this.loadType);
        this.moduleList.serialize(enc);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.userID = dec.deserializeInteger();
        this.procID = dec.deserializeInteger();
        this.procHandle = dec.deserializeInteger();
        this.loadType = dec.deserializeInteger();
        this.moduleList.deserialize(dec);
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("userID = ");
        os.print(this.userID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("procID = ");
        os.print(this.procID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("procHandle = ");
        os.print(this.procHandle.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("loadType = ");
        os.print(this.loadType.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("moduleList = ");
        this.moduleList.print(os, indent + 2);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

