/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.asnutil;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnReloadErrInfo
implements FStruct {
    public byte[] moduleName;
    public BigInteger errCode;

    public AsnReloadErrInfo() {
    }

    public AsnReloadErrInfo(AsnReloadErrInfo arg) {
        this.moduleName = new byte[arg.moduleName.length];
        System.arraycopy(arg.moduleName, 0, this.moduleName, 0, arg.moduleName.length);
        this.errCode = arg.errCode;
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.moduleName);
        enc.serializeInteger(this.errCode);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.moduleName = dec.deserializeOctetString();
        this.errCode = dec.deserializeInteger();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("moduleName = ");
        os.print(FStruFormat.convertToString((byte[])this.moduleName));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("errCode = ");
        os.print(this.errCode.toString());
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

