/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.asnutil;

import com.huawei.network.qasn.asnutil.AsnParallelTaskProgressReportList;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnProgressReportEx
implements FStruct {
    public BigInteger missionID;
    public BigInteger totalProgress;
    public AsnParallelTaskProgressReportList subTasksProgress = new AsnParallelTaskProgressReportList();
    public byte[] taskName = null;
    public byte[] detailInfo = null;

    public AsnProgressReportEx() {
    }

    public AsnProgressReportEx(AsnProgressReportEx arg) {
        this.missionID = arg.missionID;
        this.totalProgress = arg.totalProgress;
        this.subTasksProgress = new AsnParallelTaskProgressReportList(arg.subTasksProgress);
        if (arg.taskName != null) {
            this.taskName = new byte[arg.taskName.length];
            System.arraycopy(arg.taskName, 0, this.taskName, 0, arg.taskName.length);
        }
        if (arg.detailInfo != null) {
            this.detailInfo = new byte[arg.detailInfo.length];
            System.arraycopy(arg.detailInfo, 0, this.detailInfo, 0, arg.detailInfo.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.missionID);
        enc.serializeInteger(this.totalProgress);
        this.subTasksProgress.serialize(enc);
        if (this.taskName != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.taskName);
        }
        if (this.detailInfo != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeOctetString(this.detailInfo);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.missionID = dec.deserializeInteger();
        this.totalProgress = dec.deserializeInteger();
        this.subTasksProgress.deserialize(dec);
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.taskName = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.detailInfo = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("missionID = ");
        os.print(this.missionID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("totalProgress = ");
        os.print(this.totalProgress.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("subTasksProgress = ");
        this.subTasksProgress.print(os, indent + 2);
        os.println(',');
        if (this.taskName != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("taskName = ");
            os.print(FStruFormat.convertToString((byte[])this.taskName));
            os.println(',');
        }
        if (this.detailInfo != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("detailInfo = ");
            os.print(FStruFormat.convertToString((byte[])this.detailInfo));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

