/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.asnutil;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnParallelTaskProgressReport
implements FStruct {
    public BigInteger missionID;
    public BigInteger parallelTaskID;
    public BigInteger subTaskID;
    public byte[] parallelTaskName;
    public BigInteger percent;
    public BigInteger remainTime;
    public byte[] strDetail;
    public BigInteger errorCode;
    public BigInteger additionalID = null;

    public AsnParallelTaskProgressReport() {
    }

    public AsnParallelTaskProgressReport(AsnParallelTaskProgressReport arg) {
        this.missionID = arg.missionID;
        this.parallelTaskID = arg.parallelTaskID;
        this.subTaskID = arg.subTaskID;
        this.parallelTaskName = new byte[arg.parallelTaskName.length];
        System.arraycopy(arg.parallelTaskName, 0, this.parallelTaskName, 0, arg.parallelTaskName.length);
        this.percent = arg.percent;
        this.remainTime = arg.remainTime;
        this.strDetail = new byte[arg.strDetail.length];
        System.arraycopy(arg.strDetail, 0, this.strDetail, 0, arg.strDetail.length);
        this.errorCode = arg.errorCode;
        if (arg.additionalID != null) {
            this.additionalID = arg.additionalID;
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.missionID);
        enc.serializeInteger(this.parallelTaskID);
        enc.serializeInteger(this.subTaskID);
        enc.serializeOctetString(this.parallelTaskName);
        enc.serializeInteger(this.percent);
        enc.serializeInteger(this.remainTime);
        enc.serializeOctetString(this.strDetail);
        enc.serializeInteger(this.errorCode);
        if (this.additionalID != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(this.additionalID);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.missionID = dec.deserializeInteger();
        this.parallelTaskID = dec.deserializeInteger();
        this.subTaskID = dec.deserializeInteger();
        this.parallelTaskName = dec.deserializeOctetString();
        this.percent = dec.deserializeInteger();
        this.remainTime = dec.deserializeInteger();
        this.strDetail = dec.deserializeOctetString();
        this.errorCode = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.additionalID = dec.deserializeInteger();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("missionID = ");
        os.print(this.missionID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("parallelTaskID = ");
        os.print(this.parallelTaskID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("subTaskID = ");
        os.print(this.subTaskID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("parallelTaskName = ");
        os.print(FStruFormat.convertToString((byte[])this.parallelTaskName));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("percent = ");
        os.print(this.percent.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("remainTime = ");
        os.print(this.remainTime.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strDetail = ");
        os.print(FStruFormat.convertToString((byte[])this.strDetail));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("errorCode = ");
        os.print(this.errorCode.toString());
        os.println(',');
        if (this.additionalID != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("additionalID = ");
            os.print(this.additionalID.toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

