/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.asnutil;

import com.huawei.network.qasn.asnutil.AsnNEIDList;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnNMScriptImportReq
implements FStruct {
    public BigInteger userID;
    public BigInteger missionID;
    public AsnNEIDList neList = new AsnNEIDList();
    public BigInteger scriptType;
    public byte[] fileName;
    public byte[] dirName;

    public AsnNMScriptImportReq() {
    }

    public AsnNMScriptImportReq(AsnNMScriptImportReq arg) {
        this.userID = arg.userID;
        this.missionID = arg.missionID;
        this.neList = new AsnNEIDList(arg.neList);
        this.scriptType = arg.scriptType;
        this.fileName = new byte[arg.fileName.length];
        System.arraycopy(arg.fileName, 0, this.fileName, 0, arg.fileName.length);
        this.dirName = new byte[arg.dirName.length];
        System.arraycopy(arg.dirName, 0, this.dirName, 0, arg.dirName.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.userID);
        enc.serializeInteger(this.missionID);
        this.neList.serialize(enc);
        enc.serializeInteger(this.scriptType);
        enc.serializeOctetString(this.fileName);
        enc.serializeOctetString(this.dirName);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.userID = dec.deserializeInteger();
        this.missionID = dec.deserializeInteger();
        this.neList.deserialize(dec);
        this.scriptType = dec.deserializeInteger();
        this.fileName = dec.deserializeOctetString();
        this.dirName = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("userID = ");
        os.print(this.userID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("missionID = ");
        os.print(this.missionID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("neList = ");
        this.neList.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("scriptType = ");
        os.print(this.scriptType.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("fileName = ");
        os.print(FStruFormat.convertToString((byte[])this.fileName));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("dirName = ");
        os.print(FStruFormat.convertToString((byte[])this.dirName));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

