/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.asnutil;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnLineResult
implements FStruct {
    public byte[] fileName;
    public BigInteger lineNo;
    public byte[] detail;
    public BigInteger errorCode;

    public AsnLineResult() {
    }

    public AsnLineResult(AsnLineResult arg) {
        this.fileName = new byte[arg.fileName.length];
        System.arraycopy(arg.fileName, 0, this.fileName, 0, arg.fileName.length);
        this.lineNo = arg.lineNo;
        this.detail = new byte[arg.detail.length];
        System.arraycopy(arg.detail, 0, this.detail, 0, arg.detail.length);
        this.errorCode = arg.errorCode;
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.fileName);
        enc.serializeInteger(this.lineNo);
        enc.serializeOctetString(this.detail);
        enc.serializeInteger(this.errorCode);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.fileName = dec.deserializeOctetString();
        this.lineNo = dec.deserializeInteger();
        this.detail = dec.deserializeOctetString();
        this.errorCode = dec.deserializeInteger();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("fileName = ");
        os.print(FStruFormat.convertToString((byte[])this.fileName));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("lineNo = ");
        os.print(this.lineNo.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("detail = ");
        os.print(FStruFormat.convertToString((byte[])this.detail));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("errorCode = ");
        os.print(this.errorCode.toString());
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

