/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.asnutil;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnGuageNotify
implements FStruct {
    public BigInteger missionID;
    public BigInteger neID;
    public byte[] taskName;
    public BigInteger ulPercent;
    public byte[] operType;
    public BigInteger ulItemID = null;
    public byte[] strDetail = null;

    public AsnGuageNotify() {
    }

    public AsnGuageNotify(AsnGuageNotify arg) {
        this.missionID = arg.missionID;
        this.neID = arg.neID;
        this.taskName = new byte[arg.taskName.length];
        System.arraycopy(arg.taskName, 0, this.taskName, 0, arg.taskName.length);
        this.ulPercent = arg.ulPercent;
        this.operType = new byte[arg.operType.length];
        System.arraycopy(arg.operType, 0, this.operType, 0, arg.operType.length);
        if (arg.ulItemID != null) {
            this.ulItemID = arg.ulItemID;
        }
        if (arg.strDetail != null) {
            this.strDetail = new byte[arg.strDetail.length];
            System.arraycopy(arg.strDetail, 0, this.strDetail, 0, arg.strDetail.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.missionID);
        enc.serializeInteger(this.neID);
        enc.serializeOctetString(this.taskName);
        enc.serializeInteger(this.ulPercent);
        enc.serializeOctetString(this.operType);
        if (this.ulItemID != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(this.ulItemID);
        }
        if (this.strDetail != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeOctetString(this.strDetail);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.missionID = dec.deserializeInteger();
        this.neID = dec.deserializeInteger();
        this.taskName = dec.deserializeOctetString();
        this.ulPercent = dec.deserializeInteger();
        this.operType = dec.deserializeOctetString();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.ulItemID = dec.deserializeInteger();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.strDetail = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("missionID = ");
        os.print(this.missionID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("neID = ");
        os.print(this.neID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("taskName = ");
        os.print(FStruFormat.convertToString((byte[])this.taskName));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("ulPercent = ");
        os.print(this.ulPercent.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("operType = ");
        os.print(FStruFormat.convertToString((byte[])this.operType));
        os.println(',');
        if (this.ulItemID != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("ulItemID = ");
            os.print(this.ulItemID.toString());
            os.println(',');
        }
        if (this.strDetail != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strDetail = ");
            os.print(FStruFormat.convertToString((byte[])this.strDetail));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

