/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.asnutil;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnAttribValue
implements FStruct {
    public BigInteger attribID;
    public BigInteger attribAccess;
    public BigInteger intValue = null;
    public byte[] strValue = null;
    public byte[] floatValue = null;

    public AsnAttribValue() {
    }

    public AsnAttribValue(AsnAttribValue arg) {
        this.attribID = arg.attribID;
        this.attribAccess = arg.attribAccess;
        if (arg.intValue != null) {
            this.intValue = arg.intValue;
        }
        if (arg.strValue != null) {
            this.strValue = new byte[arg.strValue.length];
            System.arraycopy(arg.strValue, 0, this.strValue, 0, arg.strValue.length);
        }
        if (arg.floatValue != null) {
            this.floatValue = new byte[arg.floatValue.length];
            System.arraycopy(arg.floatValue, 0, this.floatValue, 0, arg.floatValue.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.attribID);
        enc.serializeInteger(this.attribAccess);
        if (this.intValue != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(this.intValue);
        }
        if (this.strValue != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeOctetString(this.strValue);
        }
        if (this.floatValue != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)2));
            enc.serializeOctetString(this.floatValue);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.attribID = dec.deserializeInteger();
        this.attribAccess = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.intValue = dec.deserializeInteger();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.strValue = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)2));
            this.floatValue = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("attribID = ");
        os.print(this.attribID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("attribAccess = ");
        os.print(this.attribAccess.toString());
        os.println(',');
        if (this.intValue != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("intValue = ");
            os.print(this.intValue.toString());
            os.println(',');
        }
        if (this.strValue != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strValue = ");
            os.print(FStruFormat.convertToString((byte[])this.strValue));
            os.println(',');
        }
        if (this.floatValue != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("floatValue = ");
            os.print(FStruFormat.convertToString((byte[])this.floatValue));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

