/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.asnptnnbi;

import com.huawei.network.qasn.asnptnnbi.QAsnLSPKey;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class QAsnLSPInfo
implements FStruct {
    public QAsnLSPKey lspKey = new QAsnLSPKey();
    public int bandwidth = -1;
    public Integer remainBandwidth = null;

    public QAsnLSPInfo() {
    }

    public QAsnLSPInfo(QAsnLSPInfo arg) {
        this.lspKey = new QAsnLSPKey(arg.lspKey);
        this.bandwidth = arg.bandwidth;
        if (arg.remainBandwidth != null) {
            this.remainBandwidth = arg.remainBandwidth;
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.lspKey.serialize(enc);
        enc.serializeInteger(BigInteger.valueOf(this.bandwidth));
        if (this.remainBandwidth != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(BigInteger.valueOf(this.remainBandwidth.intValue()));
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.lspKey.deserialize(dec);
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.bandwidth = bi.intValue();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.remainBandwidth = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.remainBandwidth = bi.intValue();
            }
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("lspKey = ");
        this.lspKey.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("bandwidth = ");
        os.print(this.bandwidth);
        os.println(',');
        if (this.remainBandwidth != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("remainBandwidth = ");
            os.print(this.remainBandwidth.toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

