/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.asnptnces;

import com.huawei.network.qasn.asnptnces.QAsnHighChannelList;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnPortMap
implements FStruct {
    public int portID = -1;
    public byte[] portName;
    public int portLevel = -1;
    public int isChannelized = -1;
    public int isUsed = -1;
    public int tuOrLU = -1;
    public QAsnHighChannelList channelList = new QAsnHighChannelList();

    public QAsnPortMap() {
    }

    public QAsnPortMap(QAsnPortMap arg) {
        this.portID = arg.portID;
        this.portName = new byte[arg.portName.length];
        System.arraycopy(arg.portName, 0, this.portName, 0, arg.portName.length);
        this.portLevel = arg.portLevel;
        this.isChannelized = arg.isChannelized;
        this.isUsed = arg.isUsed;
        this.tuOrLU = arg.tuOrLU;
        this.channelList = new QAsnHighChannelList(arg.channelList);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.portID));
        enc.serializeOctetString(this.portName);
        enc.serializeInteger(BigInteger.valueOf(this.portLevel));
        enc.serializeInteger(BigInteger.valueOf(this.isChannelized));
        enc.serializeInteger(BigInteger.valueOf(this.isUsed));
        enc.serializeInteger(BigInteger.valueOf(this.tuOrLU));
        this.channelList.serialize(enc);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.portID = bi.intValue();
        }
        this.portName = dec.deserializeOctetString();
        bi = dec.deserializeInteger();
        if (null != bi) {
            this.portLevel = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.isChannelized = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.isUsed = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.tuOrLU = bi.intValue();
        }
        this.channelList.deserialize(dec);
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("portID = ");
        os.print(this.portID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("portName = ");
        os.print(FStruFormat.convertToString((byte[])this.portName));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("portLevel = ");
        os.print(this.portLevel);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("isChannelized = ");
        os.print(this.isChannelized);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("isUsed = ");
        os.print(this.isUsed);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("tuOrLU = ");
        os.print(this.tuOrLU);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("channelList = ");
        this.channelList.print(os, indent + 2);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

