/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.asndatasource;

import com.huawei.network.qasn.asndatasource.AsnNameValueStrList;
import com.huawei.network.qasn.asnutil.AsnSingleReturn;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnNameValueStruct
implements FStruct {
    public BigInteger value;
    public byte[] name = null;
    public AsnNameValueStrList extend = null;
    public AsnSingleReturn result = null;
    public byte[] fdn = null;

    public AsnNameValueStruct() {
    }

    public AsnNameValueStruct(AsnNameValueStruct arg) {
        this.value = arg.value;
        if (arg.name != null) {
            this.name = new byte[arg.name.length];
            System.arraycopy(arg.name, 0, this.name, 0, arg.name.length);
        }
        if (arg.extend != null) {
            this.extend = new AsnNameValueStrList(arg.extend);
        }
        if (arg.result != null) {
            this.result = new AsnSingleReturn(arg.result);
        }
        if (arg.fdn != null) {
            this.fdn = new byte[arg.fdn.length];
            System.arraycopy(arg.fdn, 0, this.fdn, 0, arg.fdn.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.value);
        if (this.name != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.name);
        }
        if (this.extend != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            this.extend.serialize(enc);
        }
        if (this.result != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)2));
            this.result.serialize(enc);
        }
        if (this.fdn != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)3));
            enc.serializeOctetString(this.fdn);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.value = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.name = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            this.extend = new AsnNameValueStrList();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.extend.deserialize(dec);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            this.result = new AsnSingleReturn();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)2));
            this.result.deserialize(dec);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)3))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)3));
            this.fdn = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("value = ");
        os.print(this.value.toString());
        os.println(',');
        if (this.name != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("name = ");
            os.print(FStruFormat.convertToString((byte[])this.name));
            os.println(',');
        }
        if (this.extend != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("extend = ");
            this.extend.print(os, indent + 2);
            os.println(',');
        }
        if (this.result != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("result = ");
            this.result.print(os, indent + 2);
            os.println(',');
        }
        if (this.fdn != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("fdn = ");
            os.print(FStruFormat.convertToString((byte[])this.fdn));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

