/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.asncharset;

import com.huawei.network.qasn.asncharset.AsnNeStruct;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnDeviceCharsetStruct
implements FStruct {
    public AsnNeStruct neStruct = new AsnNeStruct();
    public BigInteger isCharsetChanged;
    public BigInteger charset;
    public byte[] charsetName = null;

    public AsnDeviceCharsetStruct() {
    }

    public AsnDeviceCharsetStruct(AsnDeviceCharsetStruct arg) {
        this.neStruct = new AsnNeStruct(arg.neStruct);
        this.isCharsetChanged = arg.isCharsetChanged;
        this.charset = arg.charset;
        if (arg.charsetName != null) {
            this.charsetName = new byte[arg.charsetName.length];
            System.arraycopy(arg.charsetName, 0, this.charsetName, 0, arg.charsetName.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.neStruct.serialize(enc);
        enc.serializeInteger(this.isCharsetChanged);
        enc.serializeInteger(this.charset);
        if (this.charsetName != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.charsetName);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.neStruct.deserialize(dec);
        this.isCharsetChanged = dec.deserializeInteger();
        this.charset = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.charsetName = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("neStruct = ");
        this.neStruct.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("isCharsetChanged = ");
        os.print(this.isCharsetChanged.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("charset = ");
        os.print(this.charset.toString());
        os.println(',');
        if (this.charsetName != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("charsetName = ");
            os.print(FStruFormat.convertToString((byte[])this.charsetName));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

